/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: draw.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:53 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: draw.c,v $
 * Revision 1.2  1995/02/24 23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/draw.c,v 1.2 1995/02/24 23:22:53 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"



void GENERIC_draw_next();
void draw_next();
void draw_next_plus5();
void draw_next_plus10();

void GENERIC_draw_previous();
void draw_previous();
void draw_previous_minus5();
void draw_previous_minus10();


/*****************************************************************/
/* The next three functions call the generic next displayer. 	*/
/*****************************************************************/
void draw_next(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	GENERIC_draw_next(w, data, 1);
}

void draw_next_plus5(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	GENERIC_draw_next(w, data, 5);
}

void draw_next_plus10(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	GENERIC_draw_next(w, data, 10);
}

/*****************************************************************/
/* The next three functions call the generic previous displayer. */
/*****************************************************************/
void draw_previous(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	GENERIC_draw_previous(w, data, 1);
}

void draw_previous_minus5(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	GENERIC_draw_previous(w, data, 5);
}

void draw_previous_minus10(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	GENERIC_draw_previous(w, data, 10);
}



/*****************************************************************/
/** Update the text widget displaying the selection.		**/
/*****************************************************************/
write_out_selection(w, i)
Widget w;
int i;
{
	char str[100];

	sprintf(str, "%d", i);
	XmTextSetString(w, str);

}


/*****************************************************************/
/** Draw the previous stage for the data for this processor.	**/
/*****************************************************************/
void GENERIC_draw_previous(w, data, x)
Widget w;
graphics_data *data;
int x;
{
	int temp;
	int type;
	int begin_pe = data->begin_pe;
	int end_pe = data->end_pe;
	int begin_stages = data->begin_stages;
	int end_stages = data->end_stages;

	temp = data->current;
	data->current = temp - x;

	switch (data->type) {

	case CONSTANT_STAGE:
	case TOTAL_STAGE:
		type = CONSTANT_STAGE;
		if ((data->current < begin_stages) ||
			(data->current > end_stages)) 
		{
			printf("*** ERROR *** Illegal choice of stage %d\n",
				data->current);
			data->current = begin_stages;
		}
		break;

	case CONSTANT_PE:
	case TOTAL_PE:
		type = CONSTANT_PE;
		if ((data->current < begin_pe) ||
			(data->current > end_pe)) 
		{
			printf("*** ERROR *** Illegal choice of PE %d\n",
				data->current);
			data->current = begin_pe;
		}
		break;
	}

	write_out_selection(data->selection, data->current);
	draw_display(data, type);
}


/*****************************************************************/
/** Draw the next stage for the data for this processor.	**/
/*****************************************************************/
void GENERIC_draw_next(w, data, x)
Widget w;
graphics_data *data;
int x;
{
	int temp;
	int type;
	int begin_pe = data->begin_pe;
	int end_pe = data->end_pe;
	int begin_stages = data->begin_stages;
	int end_stages = data->end_stages;

	temp = data->current;
	data->current = temp + x;

	switch (data->type) {

	case CONSTANT_STAGE:
	case TOTAL_STAGE:
		type = CONSTANT_STAGE;
		if ((data->current < begin_stages) ||
			(data->current > end_stages)) 
		{
			printf("*** ERROR *** Illegal choice of stage %d\n",
				data->current);
			data->current = end_stages;
		}
		break;

	case CONSTANT_PE:
	case TOTAL_PE:
		type = CONSTANT_PE;
		if ((data->current < begin_pe) ||
			(data->current > end_pe)) 
		{
			printf("*** ERROR *** Illegal choice of PE %d\n",
				data->current);
			data->current = end_pe;
		}
		break;
	}

	write_out_selection(data->selection, data->current);
	draw_display(data, type);
}


/*****************************************************************/
/** This function draws the range for the stages.		**/
/*****************************************************************/
void aggregate_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	int type;

	switch (data->type){

	case CONSTANT_STAGE:
	case TOTAL_STAGE:
		type = TOTAL_STAGE;
		break;

	case CONSTANT_PE:
	case TOTAL_PE:
		type = TOTAL_PE;
		break;
	}
	draw_display(data, type);
}


/*****************************************************************/
/** This function is the call back when the select button in the**/
/** command menu is pressed.					**/
/*****************************************************************/
void select_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	int type;
	char *str;
	int begin_pe = data->begin_pe;
	int end_pe = data->end_pe;
	int begin_stages = data->begin_stages;


	str = XmTextGetString(data->selection);
	data->current = atoi(str);
	switch (data->type) {

	case CONSTANT_PE:
	case TOTAL_PE:
		type = CONSTANT_PE;
		if ((data->current<begin_pe) && (data->current>end_pe))
		{
			printf("*** ERROR *** Illegal choice of processor number %d\n", 
				data->current);
			data->current = begin_pe; 
		}
		break;

	case TOTAL_STAGE:
	case CONSTANT_STAGE:
		type = CONSTANT_STAGE;
		if ((data->current<begin_stages) && (data->current>stages))
		{
			printf("*** ERROR *** Illegal choice of stage number %d\n", 
				data->current);
			data->current = begin_stages; 
		}
		break;
	}

	draw_display(data, type);
}
