/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: detailed.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/04/03 17:59:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: detailed.c,v $
 * Revision 1.4  1997/04/03 17:59:32  milind
 * Got projections to run on HPUX. Restored the timeline view.
 * Detected a bug in tachyon removal that causes -ve percentatges.
 * Haven't a clue as to why it is happening.
 * Forced a workaround.
 *
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/detailed.c,v 1.4 1997/04/03 17:59:32 milind Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "detailed.h"

void timeline_activate_callback();

/*****************************************************************/
/** This is used to set up the menu.				**/
/*****************************************************************/
static xs_menu_struct new_chare[] = {
        {"Creation", detailed_choice, CREATE_NEWCHARE},
        {"Processing", detailed_choice, PROCESS_NEWCHARE}
};

static xs_menu_struct for_chare[] = {
        {"Creation", detailed_choice, CREATE_FORCHARE},
        {"Processing", detailed_choice, PROCESS_FORCHARE}
};

static xs_menu_struct for_boc[] = {
        {"Creation", detailed_choice, CREATE_FORBOC},
        {"Processing", detailed_choice, PROCESS_FORBOC}
};

static xs_menu_struct system_msgs[] = {
        {"Load balancing", detailed_choice, PROCESS_LDB},
        {"Quiescence detection", detailed_choice, PROCESS_QD}
};


static xs_menu_struct detailed_view_system_entries[] = {
        {"New Chare Msgs", NULL, 0,
                new_chare, XtNumber(new_chare), ""},
        {"For Chare Msgs", NULL, 0,
                for_chare, XtNumber(for_chare), ""},
        {"Boc Messages", NULL, 0,
                for_boc, XtNumber(for_boc), ""},
        {"System Messages", NULL, 0,
                system_msgs, XtNumber(system_msgs), ""},
		{"", NULL, 0},
        {"Queue Size", detailed_choice, QUEUE_SIZE},
        {"Busy Time", detailed_choice, IDLE_TIME},
        {"Overhead Time", detailed_choice, OVERHEAD_TIME}
};
static xs_menu_struct detailed_view_system[] = {
	{"View-System-Attributes     ", NULL, 0, detailed_view_system_entries, 
		XtNumber(detailed_view_system_entries), ""}
}; 


static xs_menu_struct detailed_view_entries[] = {
        {"Show new timeline", timeline_activate_callback, 0}
};
static xs_menu_struct detailed_view[] = {
        {"View     ", NULL, 0,
                detailed_view_entries, XtNumber(detailed_view_entries), ""}
};

static xs_menu_struct detailed_file_entries[] = {
        {"Quit", intermediate_quit_callback, 0}
};
static xs_menu_struct detailed_file[] = {
        {"File     ", NULL, 0,
                detailed_file_entries, XtNumber(detailed_file_entries), ""}
};

static xs_menu_struct detailed_edit_entries[] = {
        {"Clear All", clearall_callback, 0},
        {"Set Parameters", parameters_callback, 0}
};
static xs_menu_struct detailed_edit[] = {
        {"Edit     ", NULL, 0,
                detailed_edit_entries, XtNumber(detailed_edit_entries), ""}
};


/*****************************************************************/
/** This structure is used to set up the command block.		**/
/*****************************************************************/

typedef struct command_info {
	char *name;
	void (*func)();
} COMMAND_INFO;

COMMAND_INFO Stage_NextForm[] = {
	" Next ",			draw_next,
	" Stage+5 ",		draw_next_plus5,
	" Stage+10 ",		draw_next_plus10
};

COMMAND_INFO Stage_PreviousForm[] = {
	" Prev ", 		draw_previous,
	" Stage-5 ", 		draw_previous_minus5,
	" Stage-10 ", 		draw_previous_minus10
};

COMMAND_INFO PE_NextForm[] = {
	" Next ",			draw_next,
	" PE+5 ",			draw_next_plus5,
	" PE+10 ",		draw_next_plus10
};

COMMAND_INFO PE_PreviousForm[] = {
	" Prev ", 		draw_previous,
	" PE-5 ", 		draw_previous_minus5,
	" PE-10 ", 		draw_previous_minus10
};


/*****************************************************************/
/** Choose this widget.                                         **/
/*****************************************************************/
void detailed_choice(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
        int n;
        int i;
        Arg wargs[10];

        n=0;
        XtSetArg(wargs[n], XmNuserData, &i); n++;
        XtGetValues(w, wargs, n);

        if (data->chosen[i])
                data->chosen[i] = 0;
        else
                data->chosen[i] = 1;
        draw_display(data, data->type);
}

set_stage_stuff(data)
graphics_data *data;
{
    data->xdivisons = data->end_pe - data->begin_pe+ 1;
    data->start_xdivs = data->begin_pe;
    data->finish_xdivs = data->end_pe;
	data->xtitle = (char *) malloc(strlen("PROCESSORS")+1);
    strcpy(data->xtitle, "PROCESSORS");
    data->xheight   = (data->xdivisons+1)*XSCALE;
    if (data->xheight < SCROLL_WIDTH)
    {
    	data->xscale = int_ceil(SCROLL_WIDTH, (data->xdivisons+1));
       	data->xheight = data->xscale*(data->xdivisons+1);
    }
    data->yheight   = DISPLAY_YHEIGHT;
	if (!within_range(data->current, data->begin_stages, data->end_stages))
	data->current = data->begin_stages;
	write_out_selection(data->selection, data->current);
}


set_pe_stuff(data)
graphics_data *data;
{
	data->xdivisons = data->end_stages - data->begin_stages + 1;
	data->start_xdivs = data->begin_stages;
    data->finish_xdivs = data->end_stages;
	data->xtitle = (char *) malloc(1000);
	sprintf(data->xtitle, "STAGES (Each stage is %d microseconds)", timestep);
	data->xheight   = (data->xdivisons+1)*XSCALE;
	if (data->xheight < SCROLL_WIDTH)
	{
		data->xscale = int_ceil(SCROLL_WIDTH, (data->xdivisons+1));
		data->xheight = data->xscale*(data->xdivisons+1);
	}
	data->yheight   = DISPLAY_YHEIGHT;
	if (!within_range(data->current, data->begin_pe, data->end_pe))
		data->current = data->begin_pe;
	write_out_selection(data->selection, data->current);
}




/*****************************************************************/
/** This function sets up various parameters for the drawing of	**/
/** histograms.							**/
/*****************************************************************/
set_detailed_parameters(data, type, begin_pe, end_pe, 
		begin_stages, end_stages)
graphics_data *data;
int type;
int begin_pe; 
int end_pe; 
int begin_stages; 
int end_stages;
{
	int n;
    int temp;
	int i, j;
	int table=0;
	int min, max;
	Arg wargs[10];
	int busy_min, busy_max;

	data->begin_pe = begin_pe;
	data->end_pe = end_pe;
	data->begin_stages = begin_stages;
	data->end_stages = end_stages;

	data->type = type;
	data->xstep = 1;
	data->xscale = XSCALE;

	min = busy_min = 9999999;
	max = busy_max = 0;


	switch (type) {

	case CONSTANT_STAGE:
		set_stage_stuff(data);

		for (table=0; table<NUMBER_DISPLAYS; table++)
		if (data->chosen[table])
		{
			for (i=begin_pe; i<=end_pe; i++)
			for (j=begin_stages; j<=end_stages; j++)
			{
				temp = display_table[table][i][j];	
                if (table != IDLE_TIME && table != OVERHEAD_TIME)
                    MIN_MAX(temp, min, max)
                else
                    MIN_MAX(temp, busy_min, busy_max)
			}
		}

		for (table=0; table<number_entries; table++)
		{
			if (data->ep_c_chosen[table])
			{
				for (i=begin_pe; i<=end_pe; i++)
				for (j=begin_stages; j<=end_stages; j++)
                	MIN_MAX(ep_c_display_table[table][i][j], min, max)
			}
			if (data->ep_p_chosen[table])
			{
				for (i=begin_pe; i<=end_pe; i++)
				for (j=begin_stages; j<=end_stages; j++)
                	MIN_MAX(ep_p_display_table[table][i][j], min, max)
			}
		}
		break;

	case TOTAL_STAGE:
		set_stage_stuff(data);
		for (table=0; table<NUMBER_DISPLAYS; table++)
		if (data->chosen[table])
		for (i=begin_pe; i<=end_pe; i++)
		{
			temp = 0;
			for (j=begin_stages; j<=end_stages; j++)
				temp += display_table[table][i][j];	
            if (table != IDLE_TIME && table != OVERHEAD_TIME)
                MIN_MAX(temp, min, max)
            else
                MIN_MAX(temp/(end_stages-begin_stages+1), busy_min, busy_max)
		}

		for (table=0; table<number_entries; table++)
		{
			if (data->ep_c_chosen[table])
			for (i=begin_pe; i<=end_pe; i++)
			{
				temp = 0;
				for (j=begin_stages; j<=end_stages; j++)
					temp += ep_c_display_table[table][i][j];	
            	MIN_MAX(temp, min, max)
			}
			if (data->ep_p_chosen[table])
			for (i=begin_pe; i<=end_pe; i++)
			{
				temp = 0;
				for (j=begin_stages; j<=end_stages; j++)
					temp += ep_p_display_table[table][i][j];	
            	MIN_MAX(temp, min, max)
			}
		}
		break;

	case CONSTANT_PE:
		set_pe_stuff(data);
        for (table=0; table<NUMBER_DISPLAYS; table++)
		{
			if (data->chosen[table])
			for (i=begin_stages; i<=end_stages; i++)
        	for (j=begin_pe; j<=end_pe; j++)
			{
             	temp = display_table[table][j][i];
            	if (table != IDLE_TIME && table != OVERHEAD_TIME)
                	MIN_MAX(temp, min, max)
             	else
                	MIN_MAX(temp, busy_min, busy_max)
        	}
		}

        for (table=0; table<number_entries; table++)
		{
			if (data->ep_c_chosen[table])
			for (i=begin_stages; i<=end_stages; i++)
        	for (j=begin_pe; j<=end_pe; j++)
			{
             	temp = ep_c_display_table[table][j][i];
             	MIN_MAX(temp, min, max)
			}
			if (data->ep_p_chosen[table])
			for (i=begin_stages; i<=end_stages; i++)
        	for (j=begin_pe; j<=end_pe; j++)
			{
             	temp = ep_p_display_table[table][j][i];
             	MIN_MAX(temp, min, max)
			}
		}
		break;

	case TOTAL_PE:
		set_pe_stuff(data);
		for (table=0; table<NUMBER_DISPLAYS; table++)
		if (data->chosen[table])
		for (i=begin_stages; i<=end_stages; i++)
		{
			temp = 0;
			for (j=begin_pe; j<=end_pe; j++)
				temp += display_table[table][j][i];	
            if (table != IDLE_TIME && table != OVERHEAD_TIME)
                MIN_MAX(temp, min, max)
            else
                MIN_MAX(temp/(end_pe-begin_pe+1), busy_min, busy_max)
                if(busy_min < 0) {
                  printf("busy_min = %d, table=%d\n", busy_min, table);
                  break;
                }
		}

		for (table=0; table<number_entries; table++)
		{
			if (data->ep_c_chosen[table])
			for (i=begin_stages; i<=end_stages; i++)
			{
				temp = 0;
				for (j=begin_pe; j<=end_pe; j++)
					temp += ep_c_display_table[table][j][i];	
            	MIN_MAX(temp, min, max)
			}
			if (data->ep_p_chosen[table])
			for (i=begin_stages; i<=end_stages; i++)
			{
				temp = 0;
				for (j=begin_pe; j<=end_pe; j++)
					temp += ep_p_display_table[table][j][i];	
            	MIN_MAX(temp, min, max)
			}
		}
		break;

	}

	if (min > max) 
	{
		 min=0;
		 max=1;
	}
	data->min = min; 
	data->max = max;
	if (busy_min > busy_max) 
	{
		busy_min=0;
		busy_max = 100;
	}
	data->busy_min = busy_min;
	data->busy_max = busy_max;

	data->ydivisons	= (max - min + 1);
	data->busy_ydivisons	= (busy_max - busy_min + 1);

	set_yscale_and_ystep( data->yheight, data->ydivisons, 
		&data->ystep, &data->yscale);
	set_yscale_and_ystep( data->yheight, data->busy_ydivisons, 
		&data->busy_ystep, &data->busy_yscale);

        n=0;
        XtSetArg(wargs[n], XtNwidth, data->xheight); n++;
        XtSetArg(wargs[n], XtNheight, data->yheight); n++;
        XtSetValues(data->canvas2, wargs, n);
}


/*****************************************************************/
/** This function is used to resize windows on receving a resize */
/** request.							**/
/*****************************************************************/
void resize_detailed_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmDrawingAreaCallbackStruct call_data;
{
	int n;
	Arg wargs[10];
	Dimension yheight;

	n=0;
	XtSetArg(wargs[n], XtNheight, &yheight); n++;
	XtGetValues(data->canvas1, wargs, n);

	if (data->yheight != yheight)
	{
		data->yheight = yheight-50;
        	n=0;
		XtSetArg(wargs[n], XtNheight, data->yheight); n++;
		XtSetValues(data->canvas2, wargs, n);
	

		set_detailed_parameters(data, data->type,
			data->begin_pe, data->end_pe,
			data->begin_stages, data->end_stages);

		draw_display(data, data->type);
	}
}



/*****************************************************************/
/** This callback is called when the button on the processor is **/
/** clicked for any of the selections. temp_data is the name of **/
/** the selection. A shell is created, and the command and 	**/
/** canvas widgets are created as children of this shell.	**/
/*****************************************************************/
void detailed_callback(w, temp_data, call_data)
Widget w;
int temp_data;
XmAnyCallbackStruct *call_data;
{
	int i;
	int n;
	Arg wargs[10];
	graphics_data *data;
	XSetWindowAttributes w_attr;

	Widget legend_scroll;
	Widget canvas_form, scrolled_window;
	Widget shell1, main_window1, framework1, menu_bar; 
	Widget command_frame, command_form, row1, row2, row3, aggregate,
			 selection;




	n=0;
        XtSetArg(wargs[n], XtNtitle, "Detailed View"); n++;
	XtSetArg(wargs[n], XmCNoResize, TRUE); n++;
	shell1 = XtCreateApplicationShell("shell1",
			topLevelShellWidgetClass,
			wargs, n);

	main_window1 = XmCreateMainWindow(shell1, "main_window1", NULL, 0);
	XtManageChild(main_window1);

	n=0;
	XtSetArg(wargs[n], XmNmarginWidth, 2); n++;
	XtSetArg(wargs[n], XmNmarginHeight, 2); n++;
	XtSetArg(wargs[n], XmNshadowThickness, 1); n++;
	XtSetArg(wargs[n], XmNshadowType, XmSHADOW_OUT); n++;
	framework1 = XtCreateManagedWidget("framework1",
			xmFormWidgetClass,
			main_window1, wargs, n);

	/*************************************************/
	/** Allocate the data area here, because it's	**/
	/** going to be used before it is actually used.**/
	/*************************************************/
	data = (graphics_data *) malloc(sizeof(graphics_data));

	/*************************************************/
	/** Create the canvas and the command frames.	**/
	/*************************************************/
	canvas_form = XtCreateManagedWidget("canvas_form", xmFormWidgetClass,
			framework1, NULL, 0);


	create_and_init_canvas(canvas_form, &data->canvas1, &data->gc1, data);

    n=0;
	XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
	XtSetArg(wargs[n], XtNwidth, SCROLL_WIDTH); n++;
	XtSetArg(wargs[n], XtNheight, SCROLL_HEIGHT); n++;
	scrolled_window = XtCreateManagedWidget("scrolled_window",
					xmScrolledWindowWidgetClass,
					canvas_form, wargs, n);

	create_and_init_canvas(scrolled_window, &data->canvas2, &data->gc2, data);

    n=0;
	XtSetArg(wargs[n], XmNworkWindow, data->canvas2); n++;
	XtSetValues(scrolled_window, wargs, n);

	create_and_init_canvas(canvas_form, &data->canvas3, &data->gc3, data);

	n=0;
	command_frame = XtCreateManagedWidget("command_frame",
			xmFrameWidgetClass,
			framework1, wargs, n);
	command_form = XtCreateManagedWidget("command_form",
			xmFormWidgetClass,
			command_frame, NULL, 0);

    n=0;
	XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
	XtSetArg(wargs[n], XtNheight, LEGEND_SCROLL_HEIGHT); n++;
	legend_scroll = XtCreateManagedWidget("legend_scroll",
					xmScrolledWindowWidgetClass,
					framework1, wargs, n);
	create_and_init_canvas(legend_scroll, &data->legend, &data->lgc, data);
    n=0;
	XtSetArg(wargs[n], XmNworkWindow, data->legend); n++;
	XtSetValues(legend_scroll, wargs, n);



	/*************************************************/
	/** Create the frame containing the quit and the**/
	/** parameters buttons.				**/
	/*************************************************/
	menu_bar = XmCreateMenuBar(main_window1, "menu_bar", NULL, 0);
	XtManageChild(menu_bar);

    data->no_toggle_buttons = 0;
    data->toggle_buttons = (WidgetList)  XtMalloc(sizeof(Widget)* 
        (count_toggle_buttons(detailed_view_system, 
				XtNumber(detailed_view_system), data) 
        + count_toggle_buttons(options_xs_struct, 1, data)));


	data_xs_create_menu_buttons(menu_bar, detailed_file,
				XtNumber(detailed_file), data);
	data_xs_create_menu_buttons(menu_bar, detailed_edit,
				XtNumber(detailed_edit), data);
	data_xs_create_menu_buttons(menu_bar, detailed_view,
				XtNumber(detailed_view), data);
	data_toggle_buttons(menu_bar, detailed_view_system,
				XtNumber(detailed_view_system), data);

	data_toggle_buttons(menu_bar, options_xs_struct, 1, data);



	/*************************************************/
	/** Now create the row column containing the next*/
	/** , previous and aggregate widgets.		**/
	/*************************************************/
	n=0;
	XtSetArg(wargs[n], XmNx, 7); n++;
	XtSetArg(wargs[n], XmNy, 10); n++;
	XtSetArg(wargs[n], XtNwidth, 75); n++;
	selection = XtCreateManagedWidget("row1",
			xmTextWidgetClass,
			command_form, wargs, n);

	n=0;
	XtSetArg(wargs[n], XmNx, 7); n++;
	XtSetArg(wargs[n], XmNy, 200); n++;
	XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(wargs[n], XmNverticalSpacing, 20); n++;
	row1 = XtCreateManagedWidget("row1",
			xmRowColumnWidgetClass,
			command_form, wargs, n);
	n=0;
	XtSetArg(wargs[n], XmNx, 7); n++;
	XtSetArg(wargs[n], XmNy, 350); n++;
	XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(wargs[n], XmNverticalSpacing, 20); n++;
	row2 = XtCreateManagedWidget("row2",
			xmRowColumnWidgetClass,
			command_form, wargs, n);
	n=0;
	XtSetArg(wargs[n], XmNx, 7); n++;
	XtSetArg(wargs[n], XmNy, 550); n++;
	XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
	XtSetArg(wargs[n], XmNverticalSpacing, 20); n++;
	row3 = XtCreateManagedWidget("row3",
			xmRowColumnWidgetClass,
			command_form, wargs, n);

	switch (temp_data) {
	case CONSTANT_STAGE:
		for (i=0; i<XtNumber(Stage_NextForm); i++)
		{
			w = XtCreateManagedWidget(Stage_NextForm[i].name, 
				xmPushButtonWidgetClass, 
				row1, NULL,  0);
			XtAddCallback(w, XmNarmCallback, 
				Stage_NextForm[i].func, data);
		}
		for (i=0; i<XtNumber(Stage_PreviousForm); i++)
		{
			w = XtCreateManagedWidget(Stage_PreviousForm[i].name, 
				xmPushButtonWidgetClass, 
				row2, NULL,  0);
			XtAddCallback(w, XmNarmCallback, 
				Stage_PreviousForm[i].func, data);
		}
		break;
	case CONSTANT_PE:
		for (i=0; i<XtNumber(PE_NextForm); i++)
		{
			w = XtCreateManagedWidget(PE_NextForm[i].name, 
				xmPushButtonWidgetClass, 
				row1, NULL,  0);
			XtAddCallback(w, XmNarmCallback, 
				PE_NextForm[i].func, data);
		}
		for (i=0; i<XtNumber(PE_PreviousForm); i++)
		{
			w = XtCreateManagedWidget(PE_PreviousForm[i].name, 
				xmPushButtonWidgetClass, 
				row2, NULL,  0);
			XtAddCallback(w, XmNarmCallback, 
				PE_PreviousForm[i].func, data);
		}
		break;
	}


	aggregate = XtCreateManagedWidget(" Aggregate ", 
			xmPushButtonWidgetClass,
			row3, NULL, 0);
	XtAddCallback(aggregate, XmNarmCallback, 
			aggregate_callback, data);


	/*************************************************/
	/** Now create the graphics data, and set up	**/
	/** parameters for this call.			**/
	/*************************************************/
	windows[current_window_pos++] = data;
	data->shell = shell1;
	data->selection = selection;
	data->current   = 0;
	data->table = 0;
	data->view_type = DETAILED_VIEW;
	data->clicks = 0;
	for (i=0; i<NUMBER_DISPLAYS; i++) data->chosen[i]=0;
	for (i=0; i<number_entries; i++) {
		data->ep_c_chosen[i]=0;
		data->ep_p_chosen[i]=0;
	}
	set_detailed_parameters(data, temp_data, 0, number_pe-1, 0, stages-1);

	/*************************************************/
	/** Now initialize some of the canvas parametes.**/
	/*************************************************/
	w_attr.backing_store = Always;

	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNbottomWidget, legend_scroll); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNleftWidget, command_frame); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(canvas_form, wargs, n);

	n=0;
	XtSetArg(wargs[n], XtNwidth, SIDES); n++;
	XtSetArg(wargs[n], XtNheight, data->yheight); n++;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetValues(data->canvas1, wargs, n);

	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNleftWidget, data->canvas1); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNrightWidget, data->canvas3); n++;
	XtSetValues(scrolled_window, wargs, n);


	n=0;
	XtSetArg(wargs[n], XtNwidth, SIDES); n++;
	XtSetArg(wargs[n], XtNheight, data->yheight); n++;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(data->canvas3, wargs, n);


	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetValues(command_frame, wargs, n);

	n=0;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNleftWidget, command_frame); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetValues(legend_scroll, wargs, n);

	n=0;
    XtSetArg(wargs[n], XtNwidth, SCROLL_WIDTH+2*SIDES); n++;
	XtSetValues(data->legend, wargs, n);

	XtRealizeWidget(shell1);

    XChangeWindowAttributes(XtDisplay(data->canvas1), XtWindow(data->canvas1),
				CWBackingStore, &w_attr);
    XChangeWindowAttributes(XtDisplay(data->canvas2), XtWindow(data->canvas2),
				CWBackingStore, &w_attr);
    XChangeWindowAttributes(XtDisplay(data->canvas3), XtWindow(data->canvas3),
				CWBackingStore, &w_attr);
    XChangeWindowAttributes(XtDisplay(data->legend), XtWindow(data->legend),
				CWBackingStore, &w_attr);
}

