/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: test.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: test.c,v $
 * Revision 1.2  1995/02/24 23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/test.c,v 1.2 1995/02/24 23:22:35 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"


write_out_log_file(filename, suffix, pe)
char *filename, *suffix;
int pe;
{
	FILE *fp;
	NODE * n;
	char name[MAXFILE];
	QUEUE_LIST *temp;
	TRANSACTION *current = transaction_table[pe].head;

	/*****************************************************************/
	/** Get the file name and open it.				**/
	/*****************************************************************/
	sprintf(name, "%s.%d.%s", filename, pe, suffix);
	fp = fopen(name, "w");
	if (fp == NULL)
		printf("*** ERROR *** Unable to open log file %s\n",
		    name);

    fprintf(fp, "%d %d\n", BEGIN_COMPUTATION, begin_time);

	/*********************************************************/
	/** Read in the entries and process them.		**/
	/*********************************************************/
	while (current)
	{
		n = current->info;
		fprintf(fp, "%d ", current->type);

		switch (current->type) {
		case CREATION:
			fprintf(fp, "%d %d %u %d %d\n", 
				n->msg_type, n->ep, n->timec, n->event, n->pe);	

			break;

		case END_PROCESSING:
			fprintf(fp, "%d %d %u %u %d %d\n",
				n->msg_type, n->ep, n->timep1, n->timep2, n->event, n->pe);	
			break;

		case ENQUEUE:
			temp = n->enqueue;
			while (temp!=NULL) {
				if (temp->ptr == current) break;
				temp = temp->next;
			}
			fprintf(fp, "%d %u %d %d\n", 
				n->msg_type, temp->time, n->event, n->pe);	
			break;

		case DEQUEUE:
			temp = n->dequeue;
			while (temp!=NULL) {
				if (temp->ptr == current) break;
				temp = temp->next;
			}
			fprintf(fp, "%d %u %d %d\n", 
				n->msg_type, temp->time, n->event, n->pe);	
			break;

		case END_INTERRUPT:
			fprintf(fp, "%u %u %d %d\n", 
					n->timep1, n->timep2, n->event, n->pe); 
				
			break;

		default:
			printf("***ERROR*** Wierd Event.\n");
			break;
		}
		current = current->next;
	}
    fprintf(fp, "%d %d\n", END_COMPUTATION, end_time);
	fclose(fp);
}


write_out_queue_sizes()
{
	int i, j;
	for (i=0; i<number_pe; i++)
	{
    	int j;
    	printf("Processor %d\n\t", i);
    	for (j=0; j<stages; j++)
        	printf("%d ", display_table[QUEUE_SIZE][i][j]);
    	printf("\n");
	}
}


print_out_stages()
{
	int i, j;
	unsigned int t;

	for (i=0; i<stages; i++)
	{
		printf("Stage %d: ", i);
		for (j=0; j<number_pe; j++)
		{
			t = GetTime(start_stage[j][i]); 
			printf("[%d] %d, %d\t", j, t, INTERVAL(t));
		}
		printf("\n");
	}
}


check_message(pe, event, msg_type, ep)
int pe, event, msg_type, ep;
{
	if ((pe>=0) && (event>=0) && (msg_type>=0) && (ep>=0))
		return;
	printf("\tMessage not ok.\n");
}

check_message_times(tc, tq, td, tp1, tp2)
unsigned int tc, tq, td, tp1, tp2;
{
	if ((tc<=tq) && (tq<=td) && (td<=tp1) && (tp1<=tp2))
		return;
	printf("\tMessage times not ok.\n");
}

print_out_messages()
{
	int i;
	NODE *n;

	for (i=0; i<HASH_TABLE_SIZE; i++)
	{
		n = hash_table[i];
		while (n != NULL)
		{
			printf("pe=%d, event=%d, msg_type=%d, ep=%d \n",
					n->pe, n->event, n->msg_type, n->ep);
			check_message(n->pe, n->event, n->msg_type, n->ep);
			if (n->enqueue && n->dequeue) {
				printf("\ttc=%u, tq=%u, td=%u, tp1=%u, tp2=%u\n",
						n->timec, n->enqueue->time, n->dequeue->time, n->timep1,
						n->timep2);
				check_message_times(n->timec, n->enqueue->time, 
						n->dequeue->time, n->timep1, n->timep2);
			}
			else
				printf("\ttc=%u, tq=-1, td=-1, tp1=%u, tp2=%u\n",
						n->timec, n->timep1, n->timep2);
			n = n->next;
		}
	}
}

verify_creations()
{
    int i, idx;
    NODE *n, *c;
	TRANSACTION_LIST *l;

    for (i=0; i<HASH_TABLE_SIZE; i++)
    {
        n = hash_table[i];
        while (n != NULL)
        {
			if ((idx = get_ep_index(n->ep, n->msg_type)) == -1) {
				n = n->next;
				continue;
			}
			if (n->creator == NULL)
				printf("No creator for pe=%d, event=%d\n", n->pe, n->event);
			else
			{
				c = n->creator->info;
				l = c->creation_list;

				/* printf("Creator is pe=%d, event=%d for pe=%d, event=%d\n",
							c->info->pe, c->info->event,
							n->pe, n->event); */
				while (l != NULL)
				{
					if (l->ptr->info == n)
						break;
					l = l->next;
				}
				if (l == NULL)
					printf("Creator does not know about pe=%d, event=%d\n",
							 n->pe, n->event);
			}


			if (n->creation_list != NULL)
			{
				l = n->creation_list;
				while (l != NULL)
				{
					if (l->ptr->info->creator->info != n)
						printf("Createe does not know about pe=%d, event=%d\n",
								l->ptr->info->pe, l->ptr->info->event);
					l=l->next;
				}
			}

            n = n->next;
        }
    }
}

print_out_queue()
{
	int i, j;

	for (i=0; i<stages; i++) {
		printf("Stage %d: ", i);
		for (j=0; j<number_pe; j++) 
			printf("%d ", display_table[QUEUE_SIZE][j][i]);
		printf("\n");
	}
}




check_queue_status()
{
	int done;
	FILE *fp;
	int pe = 0;
	int queue_size = 0;
	char name[MAXFILE];
	unsigned int time1, time2;
	int transaction_type, msg_type, entry, event_id, pe_id;

	/*****************************************************************/
	/** Get the file name and open it.				**/
	/*****************************************************************/
	done = 0;
	sprintf(name, "%s.%d.log", pgm_filename, pe);
	fp = fopen(name, "r");
	if (fp == NULL)
		printf("*** ERROR *** Unable to open log file %s\n",
		    name);

	/*********************************************************/
	/** Read in the entries and process them.		**/
	/*********************************************************/
	while (!done)
	{
		fscanf(fp, "%d", &transaction_type);

		/*************************************************/
		/** Perform appropriate actions for this entry.	**/
		/*************************************************/
		switch (transaction_type)
		{
		case CREATION:
			fscanf(fp, "%d %d %u %d %d", &msg_type, &entry,
			    &time1, &event_id, &pe_id);
			break;

		case END_PROCESSING:
			fscanf(fp, "%d %d %u %u %d %d", &msg_type, &entry,
			    &time1, &time2, &event_id, &pe_id);
			printf("%d %d: %d\n", event_id, pe_id, queue_size); 
			break;

		case ENQUEUE:
			fscanf(fp, "%d %u %d %d", &msg_type, &time1, &event_id, &pe_id);
			queue_size++;
			break;

		case DEQUEUE:
			fscanf(fp, "%d %u %d %d", &msg_type, &time1, &event_id, &pe_id);
			queue_size--;
			break;

		case END_INTERRUPT:
			fscanf(fp, "%u %u %u %u", &time1, &time2, &event_id, &pe_id);
			break;

		case BEGIN_COMPUTATION:
			fscanf(fp, "%u", &time1);
			break;

		case END_COMPUTATION:
			fscanf(fp, "%u", &time1);
			done = 1;
			fclose(fp);
			break;

		default:
			printf("***ERROR*** Wierd Event.\n");
			break;
		}
	}

}

debug_stuff()
{
	int i;

	/*
    for (i=0; i<number_pe; i++)
        write_out_log_file(pgm_filename, i);
    print_out_stages(); 
    print_out_messages(); 
	print_out_queue();
	check_queue_status();
	verify_creations();
	*/
}

int AreThereTachyons()
{
	int i;
	int found=0;
	TRANSACTION *current;

	for (i=0; i<number_pe; i++) {
		current = transaction_table[i].head;
		while (current) {
			if (current->type==BEGIN_PROCESSING)
				if (current->info->timec > current->info->timep1) {
					/*
					printf("tachyon: %d, %d, %u, %u\n",
							current->info->event,
							current->pe,
							current->info->timec,
							current->info->timep1); 
					*/
					found++;
				}
			current = current->next;
		}
	}		
	return found;
}

PrintIt(count, t)
int *count;
TRANSACTION *t;
{
	int idx = get_ep_index(t->info->ep, t->info->msg_type);
    if (!(*count)) printf("\n\t  ");
	printf("  %s (%d, %d)", grainsize_table[idx].name,
			t->info->pe, t->info->event);
	(*count)++;
	if (((*count) %2) == 0) *count=0;
}

JustDoIt(str, list)
char *str;
TRANSACTION_LIST *list;
{
	int count=0;
    TRANSACTION_LIST *new;
    new = list;
    printf("%s are: \n", str);
    while (new) {
		PrintIt(&count, new->ptr);
        new = new->next;
    }
    printf("\n");
}

CheckOutTransmissionTimes()
{
	int i, idx, *no;
	int *actual_total;
	TRANSACTION *this, *temp;

	no = (int *) malloc(sizeof(int)*number_entries); 
	actual_total  = (int *) malloc(sizeof(int)*number_entries);

	for (i=0; i<number_entries; i++)
		no[i] = actual_total[i]  = 0;

	for (i=0; i<number_pe; i++) {
		for (this=transaction_table[i].head; this; this=this->next) {
			if (this->type!=BEGIN_PROCESSING) continue;
			idx=get_ep_index(this->info->ep, this->info->msg_type);
			if (idx==-1) continue;

			temp = GetPrevious(GetPrevious(this));
			actual_total[idx] += GetTime(temp) - this->info->timec;
			no[idx]++;
		}
	}		

	for (i=0; i<number_entries; i++) 
		 printf("%s@%s: actual=%f, computed=%f\n", 
			chare_list[grainsize_table[i].chareid].name, 
			grainsize_table[i].name, 
			((double) actual_total[i])/((double) no[i]),
			(double) EpOverhead(i));
}

CheckTags() {
	int i, idx;
	TRANSACTION *this;

	for (i=0; i<number_pe; i++) {
		printf("Processor %d:\n", i);
		for (this=transaction_table[i].head; this; this=this->next) {
			if (this->type!=BEGIN_PROCESSING) continue;
			idx=get_ep_index(this->info->ep, this->info->msg_type);
			if (idx==-1) continue;

			if (this->info->tag==-1)
				printf(" %s@%s", chare_list[grainsize_table[idx].chareid].name,
						grainsize_table[i].name); 
		}
		printf("\n");
	}
}
