/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: summary.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:06:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: summary.c,v $
 * Revision 1.3  1995/09/21 21:06:13  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/summary.c,v 1.3 1995/09/21 21:06:13 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"

static int benefit=0;
static int phased=0;
static int patterned=0;
static TRANSACTION **start_event, **end_event;


/*************************************************************/
/** Some stuff that everybody needs.						**/
/*************************************************************/
percent(x, d)
unsigned int x, d;
{
	return (int) (((double) d)*((double) x))/100.0;
}


within(x, y, d)
unsigned int x, y, d;
{
	unsigned int max = y;
	unsigned int diff = abs(x-y);

	if (x>y) max = x;
	if (!max) return 1;

	if (((double) diff)/((double) max) < ((double) d)/100.0) return 1;
	return 0;
}

max(p, q)
int p, q;
{
	if (p>q) return p;
	return q;
}

/*************************************************************/
/** Determine overhead for this machine.					**/
/*************************************************************/
int EpOverhead(idx)
int idx;
{
	if (idx != -1) {
		int msg_index = grainsize_table[idx].msgid;
		return (int) machine_table[machine_type].alpha + 
			machine_table[machine_type].beta*msg_table[msg_index];
	}
	else
		return (int) machine_table[machine_type].alpha + 
			machine_table[machine_type].beta*60; 
			/* assume message is 60 bytes */
}


int Overhead(t)
TRANSACTION *t;
{
	int idx = get_ep_index(t->info->ep, t->info->msg_type);
	return EpOverhead(idx);
}

/*************************************************************/
/** determine where everything starts and ends 		**/
/*************************************************************/
determine_start_end(start, end, p, t1, t2) 
TRANSACTION **start, **end;
int p;
TRANSACTION *t1, *t2;
{
	(*start) =  find_lesser(p, t1->info->timep1);
	if (!(*start)) (*start) = transaction_table[p].head;
	(*end) = find_lesser(p, t2->info->timep2);
}

/*************************************************************/
/** Precompute stuff for this particular scenario			**/
/*************************************************************/
IGNORE_OVERALL(idx)
int idx;
{
	if (!execution_total_idx[idx]) return 1;
	if (execution_total/execution_total_idx[idx] > 5) return 1;
	return 0;
}

IGNORE(p1, p, q, idx)
int p1, p, q, idx;
{
	int frac = totalp[p-p1][idx]+totalp[q-p1][idx];
	int total = alltotal[p-p1]+alltotal[q-p1];
	if (!frac) return 1;
	if (total/frac > 5) return 1;
	return 0;
}

Precompute(data, t1, t2)
graphics_data *data;
TRANSACTION *t1, *t2;
{
	int idx1, idx2;
	TRANSACTION *t;
	int i, j, k, p, idx;
	int p2=data->end_pe; 
	int p1=data->begin_pe;

	/***************************************************************/
	/** print out this sync. pair **/
	/***************************************************************/
    idx1 = get_ep_index(t1->info->ep, t1->info->msg_type);
    idx2 = get_ep_index(t2->info->ep, t2->info->msg_type);

	/***************************************************************/
	/** Determine starting and ending points for all processors.	**/
	/***************************************************************/
	for (p=p1; p<=p2; p++) 
		determine_start_end(&start_event[p-p1], &end_event[p-p1], p, t1, t2);

    /* calculate everything for these two sync points */
    for (p=p1; p<=p2; p++) {
        for (t=start_event[p-p1]; t!=end_event[p-p1]; t=t->next) {
            if (t->type==BEGIN_PROCESSING) {
                idx = get_ep_index(t->info->ep, t->info->msg_type);
                if (idx==-1) continue;
                if (t->info->msg_type==NewChareMsg) {
					charesp[p-p1]++;
					chare_entries[idx]=1;
				}
                if (t->info->msg_type==ForChareMsg) {
					forcharesp[p-p1]++;
					forchare_entries[idx]=1;
				}
                if (t->info->msg_type==BocMsg) {
					bocsp[p-p1]++;
					boc_entries[idx]=1;
				}
                totalp[p-p1][idx] += t->info->timep2 - t->info->timep1;
				alltotal[p-p1] += t->info->timep2 - t->info->timep1;
                numberp[p-p1][idx]++;
            }
        }

    	for (idx=0; idx<number_entries; idx++) {
        	if (numberp[p-p1][idx]) 
        		grainp[p-p1][idx] = totalp[p-p1][idx]/numberp[p-p1][idx];
    	}
    }

	/**************************/
	/** add to global counts **/
	/**************************/
	for (p=p1; p<=p2; p++) {
		execution_total += alltotal[p-p1];
    	for (idx=0; idx<number_entries; idx++) 
			execution_total_idx[idx] += totalp[p-p1][idx];
	}


}

/*************************************************************/
/** Does overall analysis.									**/
/*************************************************************/
SummaryExpert(data)
graphics_data *data;
{
	int i, j, total;	

	TRANSACTION_LIST 	*current, *next;
	TRANSACTION_LIST 	*DetermineSyncPoints();

	int begin_pe = data->begin_pe; 
	int end_pe = data->end_pe;
	int begin_stages = data->begin_stages; 
	int end_stages = data->end_stages; 

	type_of_analysis = SUMMARY_ANALYSIS;

	AllocStuff(begin_pe, end_pe);
	CriticalPath(critical_entries);

	if (!phased) {
		phased=1;
		printf("Determining phases in program execution.\n");
		sync_list = DetermineSyncPoints();
	}

	/***************************************************/
	/** check if sync_list is ok. **/
	/***************************************************/
	for (current=sync_list; current; current=current->next) {
		if (current->next &&
				(current->ptr->info->timep2 > current->next->ptr->info->timep1))
					printf("*** ERROR *** incorrect synchronization list.\n");
	}

	/***************************************************/
	/** Now try and determine patterns **/
	/***************************************************/
	if (!patterned) {
		patterns = (int **) malloc(sizeof(int *)*number_entries);
			for (i=0; i<number_entries; i++) {
				patterns[i] = (int *)malloc(sizeof(int)*NUMBER_PATTERNS);
				for (j=0; j<NUMBER_PATTERNS; j++) patterns[i][j] = 0;
			}

		printf("Determining patterns");
		fflush(stdout);
		for (current=sync_list; current->next; current=current->next) { 
			DeterminePatterns(data, current->ptr, current->next->ptr);
			printf(".");
		fflush(stdout);
		}
		patterned=1;
		printf("\n");

		/***********
		for (i=0; i<number_entries; i++) {
            printf("%s@%s: ", chare_list[grainsize_table[i].chareid].name,
            				grainsize_table[i].name);
			for (j=0; j<NUMBER_PATTERNS; j++)
				printf("%d ", patterns[i][j]);
			printf("\n");
		}
		**********/
	}

	/***************************************************/
	mysprintf("******************************************\n");
	mysprintf("*****  PHASE-BY-PHASE ANALYSIS  **********\n");
	mysprintf("******************************************\n");
	for (i=0; i<number_entries; i++) execution_total_idx[i]=0;

	printf("Analyzing program");
	fflush(stdout);
	for (current=sync_list; current->next; current=current->next) {

		int util=0;
		int stage1, stage2;


		printf("."); 
		fflush(stdout);
		/***************************************************/
		/** initialize everything to zero **/
		/***************************************************/
		for (i=0; i<MAX_PROBLEMS; i++) crime_sheet[i] = 0;
		for (i=0; i<number_entries; i++) {
			large_ep[i] = 0;
			branchinit_entries[i] = tail_end_entries[i] = 
			seq_chain_entries[i] = bottleneck_entries[i] = 
			grain_imbalance[i] = chare_imbalance[i] = 
			forchare_imbalance[i] = boc_imbalance[i] = 
			fine_grain_problem[i] = 
			chare_entries[i] = forchare_entries[i] = boc_entries[i] = 0;
		}
		for (i=begin_pe; i<=end_pe; i++) { 
			for (j=0; j<number_entries; j++) totalp[i-begin_pe][j] =
					numberp[i-begin_pe][j] = grainp[i-begin_pe][j] =  0;
			alltotal[i-begin_pe] = bocsp[i-begin_pe] =
				forcharesp[i-begin_pe] =  charesp[i-begin_pe] =0;
		}
		InitWaitStuff();
		severe_ldb_interference=severe_qd_interference=1;




		/***************************************************/
		/** determine start and end points.				**/
		/***************************************************/
		next = current->next;
		stage1 = INTERVAL(current->ptr->info->timep1);
		stage2 = INTERVAL(next->ptr->info->timep1);

		for (i=stage1; i<=stage2; i++)
			for (j=0; j<number_pe; j++) 
            	util += display_table[IDLE_TIME][j][i];
        util /= number_pe*(stage2-stage1+1);

		sprintf(temp_string, "Stages %d --- %d\n", stage1, stage2);
		mysprintf(temp_string);

		Precompute(data, current->ptr, next->ptr);
		PrintSummaryStuff(data->begin_pe, data->end_pe, 
								current->ptr, next->ptr);

		if (util < 75) { 
			SystemIdiosyncracy(data, current->ptr, next->ptr);
			CheckOtherProblems(data, current->ptr, next->ptr);
		}
		else mysprintf("No serious problems detected.\n");

		DetermineBenefits(data->begin_pe, data->end_pe);
		/* Combine(local_problem_benefit, crime_sheet); */
		AddToGlobalStuff(current->ptr, next->ptr);
		Report(local_problem_benefit, crime_sheet, 
					GetTime(current->ptr), 
					GetTime(next->ptr));
		mysprintf("----------------------------------------------------------------------\n");

	}
	printf("\n");


	EvaluateLdb();
	AnalyzeTables(data);

	mysprintf("******************************************\n");
	mysprintf("***********  SUMMARY ANALYSIS  ***********\n");
	mysprintf("******************************************\n");
	FreeStuff(begin_pe, end_pe);
	PointToGlobalStuff();
	Report(global_problem_benefit, global_crime_sheet, begin_time, end_time);
	FreeGlobalStuff();
}

int SystemIdiosyncracy(data, t1, t2)
graphics_data *data;
TRANSACTION *t1, *t2;
{
	int idx;
	int i, j;
	int count=0;
	TRANSACTION *t;
	int p2 = data->end_pe;
	int p1 = data->begin_pe;
	int s1=INTERVAL(t1->info->timep1);
	int s2=INTERVAL(t2->info->timep1);
	unsigned int tcharminit, tbocinit;

	benefit=0;
	for (i=s1; i<=s2; i++) if (stage_status[0][i] == CHARMINIT) count++;
	if (!count) return;
	if ((100*count)/(s2-s1+1) > 20) { 
		for (t=transaction_table[0].head; t->info->ep!=charminit_id; t=t->next);
		tcharminit = t->info->timep2 - t->info->timep1;
		benefit = (tcharminit - EpOverhead(-1))/(p2-p1+1);
		update_crime(CHARMINIT_PROBLEM, benefit);
		for (; t->type!=END_PROCESSING && t->info->ep!=charminit_id; 
				t=t->next) {
			if (t->info->msg_type==BocInitMsg)
				tbocinit = t->info->timep2 - t->info->timep1;
			if (within(tbocinit, tcharminit, 75)) { 
				benefit = (tbocinit - EpOverhead(-1))/(p2-p1+1);
				update_crime(BRANCHINIT_PROBLEM, benefit);
				idx = get_ep_index(t->info->ep, t->info->msg_type);
				branchinit_entries[idx] = 1;
			}	
		}
	}
	else 
		update_crime(CHARMINIT_NOPROBLEM, benefit);
}

int CheckOtherProblems(data, t1, t2)
graphics_data *data;
TRANSACTION *t1, *t2;
{
	int i, j;
	int idx, ep;
	int p, p1, p2;
	TRANSACTION *t;
	int dop=0, dopc=0;
    int countq=0, countnq = 0;
	
	p1=data->begin_pe;
	p2=data->end_pe; 



    for (p=p1; p<=p2; p++) {

        for (t=start_event[p-p1]; t!=end_event[p-p1]; t=t->next) {

            if (!t) break;
            if (t->type != BEGIN_PROCESSING) continue;
            if ((idx = get_ep_index(t->info->ep,
                    t->info->msg_type)) == -1) continue;

            if (GetTime(t) > GetTime(t1))
                if (!t->queue) countnq++;
                else countq++;
        }
    }
    if (countq) ProcessorHasWork(data, t1, t2, p1, p2);
    if (countnq) ProcessorHasNoWork(data, t1, t2, p1, p2);

}


int ProcessorHasNoWork(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
    /* processors have no work to do */
	IsLoadUnbalanced(data, t1, t2, p1, p2);
	IsOverheadUnbalanced(data, t1, t2, p1, p2);

	WaitAnalysis(data, t1, t2, p1, p2);
}

int ProcessorHasWork(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
	IsThereSystemInterference(data, t1, t2, p1, p2);
	IsThereAGrainsizeProblem(data, t1, t2, p1, p2);
}



int IsThereAGrainsizeProblem(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
	int p;
	int ep, idx;
	TRANSACTION *t;
	char is_there_a_problem;
	unsigned int grain, total;

	is_there_a_problem=HAVE_NO_PROBLEM;
	for (p=p1; p<=p2; p++) {

		total=0;
		for (idx=0; idx<number_entries; idx++) total += totalp[p-p1][idx];
		for (idx=0; idx<number_entries; idx++) {
			grain=grainp[p-p1][idx];
			if (grain<EpOverhead(idx) && totalp[p-p1][idx] &&
					(total/totalp[p-p1][idx]<5)) { 
				if (!fine_grain_problem[idx]) {
					is_there_a_problem=HAVE_PROBLEM;
					fine_grain_problem[idx]=1;
				}
			}
		}
	}	
}

int IsThereSystemInterference(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
	int p;
	int idx;
	TRANSACTION *t;
	unsigned int ldbs, qds, totals, totalu;
	int ldb_necessary=0, ldb_poor=0, parallelism_insufficient=0;

	/* now check for system interference */
	/* we have already checked for charminit, branchinit, logfile */
	/* check for whatever's left */
	/* that may involve checking for load balancing, quiescence, table */
	totalu=ldbs=qds=totals=0;
	for (p=p1; p<=p2; p++) {
        for (t=start_event[p-p1]; t!=end_event[p-p1]; t=t->next) {
			if (!t) break;
			if (t->type != BEGIN_PROCESSING) continue;
			idx = get_ep_index(t->info->ep, t->info->msg_type);
			if (idx == -1) {
				if (IsLdbMsg(t)) ldbs++;
				else if (IsQdMsg(t)) {
					qds++;
					if (qds > totalu) {
						int interval = INTERVAL(t->info->timep1);
						global_status[QD_INTERFERENCE][interval] = 1;
					}
				}
				totals++;
			}
			else {
				totalu++;
				if (totals>totalu && qds>totalu/5)
					if (ldbs) {
						if (t->info->dop > 0) ldb_necessary=1;
						if (ldbs>totalu/3) 
							if (t->info->dop > 2*(p2-p1+1)) ldb_poor++;
							else parallelism_insufficient++;
					}
			}
		}
	}
	benefit=0;
	if (!ldb_necessary) {
		benefit = (ldbs*EpOverhead(-1))/(p2-p1+1);
		update_crime(UNNECESSARY_LDB, benefit);
	}
	if (parallelism_insufficient && parallelism_insufficient>totalu/5) {
		benefit = ((ldbs+qds)*EpOverhead(-1))/(p2-p1+1);
		update_crime(LOW_PARALLELISM, benefit);
	}
	if (ldb_poor && ldb_poor>totalu/5) {
		benefit = ((ldbs+qds)*EpOverhead(-1))/(p2-p1+1);
		update_crime(POOR_LDB, benefit);
	}

	if (totals > totalu)  {
		benefit = ((totals - totalu/5)*EpOverhead(-1))/(p2-p1+1);
		update_crime(SYSTEM_INTERFERENCE, benefit);
		if (ldbs && totals/ldbs<5) {
			benefit = ((ldbs - totalu/5)*EpOverhead(-1))/(p2-p1+1);
			update_crime(LDB_INTERFERENCE, benefit);
		}
		if (qds && totals/qds<5) {
			benefit = ((qds - totalu/5)*EpOverhead(-1))/(p2-p1+1);
			update_crime(QD_INTERFERENCE, benefit);
		}
	}

	if (totals>3*totalu) { 
		if (ldbs && totals/ldbs<5) severe_ldb_interference=1;
		if (qds && totals/qds<5) severe_qd_interference=1;
	}
}


int IsLoadUnbalanced(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
	int i, j, p;
	int benefit;
	TRANSACTION *t;
	int chare_problem=0, forchare_problem=0, boc_problem=0, grain_problem=0;

	for (p=p1; p<=p2; p++) {

		/* check whether new chare messages were Unbalanced */
		for (i=p+1; i<=p2; i++) {  
 			if (!within(charesp[p-p1], charesp[i-p1], 20)) {
				for (j=0; j<number_entries; j++) {
					if (IGNORE(p1, p, i, j)) continue;
					if (!chare_entries[j]) continue;
					if (!charesp[p-p1]) continue;
					if (!charesp[i-p1]) continue;
					if (!within(numberp[p-p1][j], numberp[i-p1][j], 20))  
						chare_problem = chare_imbalance[j] = 1;
				}
				break;
			}
		}

		/* check whether boc messages were Unbalanced */
		for (i=p+1; i<=p2; i++)   {
 			if (!within(forcharesp[p-p1], forcharesp[i-p1], 20)) { 
				for (j=0; j<number_entries; j++) {
					if (IGNORE(p1, p, i, j)) continue;
					if (!forchare_entries[j]) continue;
					if (!within(numberp[p-p1][j], numberp[i-p1][j], 20)) 
						forchare_problem = forchare_imbalance[j] = 1;
				}
				break;
			}
		}	
	
		/* check whether boc messages were Unbalanced */
		for (i=p+1; i<=p2; i++)   {
 			if (!within(bocsp[p-p1], bocsp[i-p1], 20)) { 
				for (j=0; j<number_entries; j++) {
					if (IGNORE(p1, p, i, j)) continue;
					if (!boc_entries[j]) continue;
					if (!within(numberp[p-p1][j], numberp[i-p1][j], 20)) 
						boc_problem = boc_imbalance[j] = 1;
				}
				break;
			}
		}	
	
		/* check whether grain size of messages were Unbalanced */
		for (i=p+1; i<=p2; i++) {  
			for (j=0; j<number_entries; j++) {
				if (IGNORE(p1, p, i, j)) continue;
					if (!grainp[p-p1][j]) continue;
					if (!grainp[i-p1][j]) continue;
				if (!within(grainp[p-p1][j], grainp[i-p1][j], 20))
						grain_problem = grain_imbalance[j] = 1;
			}
		}	
	}
}

int IsOverheadUnbalanced(data, t1, t2, p1, p2)
graphics_data *data;
TRANSACTION *t1, *t2;
int p1, p2;
{
	int i, p;
	TRANSACTION *t;
	int max, total;
	int bocsp, bocsi;
	char is_there_a_problem=HAVE_NO_PROBLEM;

	benefit=0;
	max=total=0;
	for (p=p1; p<=p2; p++) {

		bocsp=0;
        for (t=start_event[p-p1]; t!=end_event[p-p1]; t=t->next) {
			if (!t) break;
			if (t->type==BEGIN_PROCESSING && IsSystemBocMsg(t)) bocsp++;
		}

		if (bocsp > max) max = bocsp;
		total += bocsp;

		for (i=p+1; i<=p2; i++) { 

			/* check whether boc messages were Unbalanced */
			bocsi=0;
        	for (t=start_event[p-p1]; t!=end_event[p-p1]; t=t->next) {
				if (!t) break;
				if (t->type==BEGIN_PROCESSING && IsSystemBocMsg(t)) bocsi++;
			}
	 		if (!within(bocsp, bocsi, 20)) is_there_a_problem = HAVE_PROBLEM;
		}	
	}
	if (is_there_a_problem) {
		benefit += (max-total/(p2-p1+1))*EpOverhead(-1);
		update_crime(OVERHEAD_IMBALANCE, benefit);
	}
}


int AllocStuff(p1, p2)
int p1, p2;
{
	int i, j, k;

    branchinit_entries = (char *) malloc(sizeof(char)*number_entries);
    seq_chain_entries = (char *) malloc(sizeof(char)*number_entries);
    bottleneck_entries = (char *) malloc(sizeof(char)*number_entries);
    both_large_and_tail = (char *) malloc(sizeof(char)*number_entries);
    tail_end_entries = (char *) malloc(sizeof(char)*number_entries);
    large_ep = (char *) malloc(sizeof(char)*number_entries);
    fine_grain_problem = (char *) malloc(sizeof(char)*number_entries);
    grain_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    chare_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    forchare_imbalance  = (char *) malloc(sizeof(char)*number_entries);
    boc_imbalance  = (char *) malloc(sizeof(char)*number_entries);

    crime_sheet = (char *) malloc(sizeof(char)*MAX_PROBLEMS);

    critical_entries = (int *) malloc(sizeof(int) * number_entries);
    other_entries = (int *) malloc(sizeof(int) * number_entries);

    for (i=0; i<number_entries; i++)
        critical_entries[i] = other_entries[i] = 0;

    /* alloc and initialize stuff */
    boc_entries = (char *) malloc(sizeof(char) * number_entries);
    chare_entries = (char *) malloc(sizeof(char) * number_entries);
    forchare_entries = (char *) malloc(sizeof(char) * number_entries);

    charesp = (int *) malloc(sizeof(int)*(p2-p1+1));
    forcharesp = (int *) malloc(sizeof(int)*(p2-p1+1));
    bocsp = (int *) malloc(sizeof(int)*(p2-p1+1));
    alltotal = (int *) malloc(sizeof(int)*(p2-p1+1));
    totalp = (int **) malloc(sizeof(int *)*(p2-p1+1));
    numberp = (int **) malloc(sizeof(int *)*(p2-p1+1));
    grainp = (int **) malloc(sizeof(int *)*(p2-p1+1));
    for (i=p1; i<=p2; i++) {
        totalp[i-p1] = (int *) malloc(sizeof(int)*number_entries);
        numberp[i-p1] = (int *) malloc(sizeof(int)*number_entries);
        grainp[i-p1] = (int *) malloc(sizeof(int)*number_entries);
    }
    execution_total_idx = (int *) malloc(sizeof(int)*number_entries);

    start_event = (TRANSACTION **) malloc(sizeof(TRANSACTION *)*(p2-p1+1));
    end_event = (TRANSACTION **) malloc(sizeof(TRANSACTION *)*(p2-p1+1));

	AllocWaitStuff();
	AllocGlobalStuff();
}

int FreeStuff(p1, p2)
int p1, p2;
{
	int i;
    free(branchinit_entries);
    free(both_large_and_tail);
    free(tail_end_entries);
    free(bottleneck_entries);
    free(seq_chain_entries);
	free(large_ep);
    free(fine_grain_problem);
    free(chare_imbalance);
    free(forchare_imbalance);
    free(boc_imbalance);
    free(grain_imbalance);
    free(crime_sheet);
	free(critical_entries);
	free(other_entries);
	/* free stuff */
    free(boc_entries); 
    free(chare_entries);
    free(forchare_entries);
	free(charesp);
	free(forcharesp);
	free(bocsp);
	for (i=p1; i<=p2; i++) {
		free(numberp[i-p1]);
		free(grainp[i-p1]);
		free(totalp[i-p1]);
	}
	free(numberp);
	free(grainp);
	free(totalp);
	free(alltotal);
	free(execution_total_idx);
	
	FreeWaitStuff();
}


PrintSummaryStuff(p1, p2, t1, t2)
int p1, p2;
TRANSACTION *t1, *t2;
{
	int p;
	int idx, idx1, idx2;

	return;

    idx1 = get_ep_index(t1->info->ep, t1->info->msg_type);
    idx2 = get_ep_index(t2->info->ep, t2->info->msg_type);

    printf("--------------------------------------\n");
    printf("SYNC: start=%s@%s (stage %d), end=%s@%s (stage %d)\n\n",
            chare_list[grainsize_table[idx1].chareid].name,
            grainsize_table[idx1].name,
            INTERVAL(GetTime(t1)),
            chare_list[grainsize_table[idx2].chareid].name,
            grainsize_table[idx2].name,
            INTERVAL(GetTime(t2)));

    /***************************************************************/
    /** print out starting and ending events.                   **/
    /***************************************************************/
    /*************
    for (p=p1; p<=p2; p++) {
        TRANSACTION *temp1, *temp2;
        temp1 = start_event[p-p1];
        temp2 = end_event[p-p1];
        printf("Processor %d: start=0x%X end=0x%x\n", p, temp1, temp2);
        if (temp1)
            printf("Processor %d start: (%d, %d), %u\n", p,
                temp1->info->pe, temp1->info->event, GetTime(temp1));
        if (temp2)
            printf("Processor %d end: (%d, %d), %u\n", p,
                temp2->info->pe, temp2->info->event, GetTime(temp2));
    }
    **************/

	/******************************************************/
	/* Print the number of charesp, bocsp, etc.			**/
	/******************************************************/
    /*************
	printf("\tcharesp:");
	for (p=p1; p<=p2; p++) printf("%d ", charesp[p-p1]);
	printf("\n\tforcharesp:");
	for (p=p1; p<=p2; p++) printf("%d ", forcharesp[p-p1]);
	printf("\n\tbocsp:");
	for (p=p1; p<=p2; p++) printf("%d ", bocsp[p-p1]);
	printf("\n\talltotal:");
	for (p=p1; p<=p2; p++) printf("%d ", alltotal[p-p1]);
	printf("\n");

    for (idx=0; idx<number_entries; idx++) {
        printf("%s@%s: \n", chare_list[grainsize_table[idx].chareid].name, 
            grainsize_table[idx].name);

		printf("\t numberp:");
		for (p=p1; p<=p2; p++) printf("%d ", numberp[p-p1][idx]);
		printf("\n");

		printf("\t totalp:");
		for (p=p1; p<=p2; p++) printf("%d ", totalp[p-p1][idx]);
		printf("\n");

		printf("\t grainp:");
		for (p=p1; p<=p2; p++) printf("%d ", grainp[p-p1][idx]);
		printf("\n");
	}
    **************/
}

/*********************************************************************/
/** Now figure out all the costs.									**/
/*********************************************************************/


DetermineBenefits(p1, p2)
int p1, p2;
{
	int j;

    /********************************************************/
    /* determine possible benefits of solving imbalance problems. **/
    /********************************************************/
	for (j=0; j<number_entries; j++)
		if (chare_imbalance[j]) 
			update_crime(CHARE_IMBALANCE, EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (forchare_imbalance[j]) 
			update_crime(FORCHARE_IMBALANCE, EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (boc_imbalance[j]) 
			update_crime(BOC_IMBALANCE, EntryImbalanceCost(p1, p2, j));

	for (j=0; j<number_entries; j++)
		if (grain_imbalance[j]) 
			update_crime(GRAIN_IMBALANCE, EntryImbalanceCost(p1, p2, j));

    /********************************************************/
	/** determine benefits of fine grained solutions **/
    /********************************************************/
	for (j=0; j<number_entries; j++)
		if (fine_grain_problem[j]) 
			update_crime(FINE_GRAIN_PROBLEM, FineGrainCost(p1, p2, j));

	DetermineWaitBenefits(p1, p2);
}


int EntryImbalanceCost(p1, p2, idx)
int p1, p2, idx;
{
	int i;
	int count=0;
	unsigned int total, max;
	
	total=max=0;
	for (i=p1; i<=p2; i++) {
		if (!totalp[i-p1][idx]) continue;
		count++;
		total += totalp[i-p1][idx];
		if (totalp[i-p1][idx] > max) max = totalp[i-p1][idx];
	}
	total /= count;
	return (max-total);
}

int FineGrainCost(p1, p2, idx)
int p1, p2, idx;
{
	int i;
	int no;
	unsigned int total;

	total = no = 0;
	for (i=p1; i<=p2; i++) {
		no += numberp[i-p1][idx];
		total += totalp[i-p1][idx];
	}

	return (no*EpOverhead(idx) - total)/(p2-p1+1);
}
