/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: shared.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:22:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: shared.c,v $
 * Revision 1.2  1995/02/24 23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/shared.c,v 1.2 1995/02/24 23:22:35 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#define SHARED
#include "shared.h"
#undef SHARED


/*************************************************************/
/** Table analysis follows 									**/
/*************************************************************/

InitHashKeys()
{
	int i;
	for (i=0; i<MAX_HASH_KEYS; i++)
		hash_keys[i] = NULL;
}

FreeHashKeys()
{
	int i;
	KEY_ENTRY *t1, *t2;
	for (i=0; i<MAX_HASH_KEYS; i++) {
		t1 = hash_keys[i];
		while (t1) {
			t2 = t1->next;
			free(t1->inserts); free(t1->deletes); free(t1->finds);
			free(t1);
			t1 = t2;
		}
	}
}

KEY_ENTRY *FindKey(k)
int k;
{
	KEY_ENTRY *t = hash_keys[KeyHash(k)];

	while (t) {
		if (t->key == k) return t;
		t = t->next;
	}
	return NULL;
}

KEY_ENTRY *InsertKey(k, to)
int k, to;
{
	int i;
	int index = KeyHash(k);
	KEY_ENTRY *t = (KEY_ENTRY *) malloc(sizeof(KEY_ENTRY));
	t->key = k;
	t->location = to;
	t->inserts = (int *) malloc(sizeof(int)*number_pe);
	t->deletes = (int *) malloc(sizeof(int)*number_pe);
	t->finds = (int *) malloc(sizeof(int)*number_pe);
	for (i=0; i<number_pe; i++)
		t->inserts[i] = t->deletes[i] = t->finds[i] = 0;
	t->next = hash_keys[index];
	hash_keys[index] = t;
	return t;
}


AddOperation(operation, where, to, key)
int operation, where, to, key;
{
	KEY_ENTRY *t = FindKey(key);
	if (!t) t = InsertKey(key, to);

/* printf("AddOperation: operation=%d, where=%d, to=%d, key=%d\n",
operation, where, to, key); */

	switch (operation) {

	case INSERT:
		t->inserts[where]++;
		break;

	case DELETE:
		t->deletes[where]++;
		break;

	case FIND:
		t->finds[where]++;
		break;

	default:
		printf("*** ERROR *** Illegal table operation %d\n", operation);
	}
}

non_local(X, p)
int *X, p;
{
	int i;
	int count = 0;
	for (i=0; i<number_pe; i++)
		if (i!=p) count+= X[i];
	return count;
}

AreOperationsUnbalanced()
{
	int i, j;
	KEY_ENTRY *t;
	int max_dis, maxi, maxd, maxf;
	int min_dis, mini, mind, minf;
	int *total_dis, *totali, *totald, *totalf;
	int is_there_a_problem = HAVE_NO_PROBLEM;

	totali = (int *) malloc(sizeof(int)*number_pe);
	totald = (int *) malloc(sizeof(int)*number_pe);
	totalf = (int *) malloc(sizeof(int)*number_pe);
	total_dis = (int *) malloc(sizeof(int)*number_pe);
	for (i=0; i<number_pe; i++)
		total_dis[i] = totali[i] =  totald[i] = totalf[i] = 0;
		
	for (i=0; i<MAX_HASH_KEYS; i++) {
		t = hash_keys[i];
		while (t) {
			for (j=0; j<number_pe; j++) {
				totali[j] += t->inserts[j];
				totald[j] += t->deletes[j];
				totalf[j] += t->finds[j];
			}
			totali[t->location] -= non_local(t->inserts, t->location);
			totald[t->location] -= non_local(t->deletes, t->location);
			totalf[t->location] -= non_local(t->finds, t->location);
			total_dis[t->location] += t->inserts[t->location];
			t = t->next;
		}
	}

	min_dis = max_dis = total_dis[0];
	mini = maxi = totali[0];
	mind = maxd = totald[0];
	minf = maxf = totalf[0];
	for (i=1; i<number_pe; i++) {
		if (total_dis[i] > max_dis) max_dis = total_dis[i];
		if (totali[i] > maxi) maxi = totali[i];
		if (totali[i] > maxd) maxd = totald[i];
		if (totali[i] > maxf) maxf = totalf[i];

		if (total_dis[i] < min_dis) min_dis = total_dis[i];
		if (totali[i] < mini) mini = totali[i];
		if (totali[i] < mind) mind = totald[i];
		if (totali[i] < minf) minf = totalf[i];
	}

	if (!within(min_dis, max_dis, 20)) {
		mysprintf("\t- Distribution of entries not balanced.\n");
		is_there_a_problem = HAVE_PROBLEM;
	};
	if (!within(mini, maxi, 20)) {
		mysprintf("\t- Insert requests not balanced.\n");
		is_there_a_problem = HAVE_PROBLEM;
	};
	if (!within(mind, maxd, 20)) {
		mysprintf("\t- Delete requests not balanced.\n");
		is_there_a_problem = HAVE_PROBLEM;
	};
	if (!within(minf, maxf, 20)) {
		mysprintf("\t- Find requests not balanced for table.\n");
		is_there_a_problem = HAVE_PROBLEM;
	};
/*
printf("min_dis=%d, max_dis=%d\n", min_dis, max_dis);
printf("mini=%d, maxi=%d\n", mini, maxi);
printf("mind=%d, maxd=%d\n", mind, maxd);
printf("minf=%d, maxf=%d\n", minf, maxf);
*/
	free(totali); free(totald); free(totalf);
	return is_there_a_problem; 
}

IsLocalityPossible()
{
	int i, j;
	int location;
	KEY_ENTRY *t;
	int totaln, totall;
	int goodk=0, badk=0, diffk=0, nodiff=0;

	for (i=0; i<MAX_HASH_KEYS; i++) {
		t = hash_keys[i]; 
		while (t) {
			diffk=0;
			totaln = 0;
			location = t->location;
			totall = t->inserts[location] + t->deletes[location] +
					t->finds[location];
			for (j=0; j<number_pe; j++)
				if (j != location) { 
					totaln += t->inserts[j] + t->deletes[j]  + t->finds[j];
					diffk++;
				}
			if (totaln  > totall) badk++;
			if (diffk > percent(number_pe, 66)) nodiff++;
			else goodk++;
			t = t->next;			
		}
	}
	if (badk>goodk || (!within(badk, goodk+badk, 66)))  {
		mysprintf("\t- Analysis shows potential for better locality. Many table requests are \n\tmade for non-local entries. \n");
		if (within(badk,nodiff,66))
			mysprintf("\t- Better locality may be achieved if table entries are made into read only variables.\n");
	}
}

IsCachingPossible()
{
	int i, j;
	KEY_ENTRY *t;
	int goodk=0, badk=0;

	for (i=0; i<MAX_HASH_KEYS; i++) {
		t = hash_keys[i]; 
		while (t) {
			if (t->finds[t->location] > 2) badk++;
			else goodk++;
			t = t->next;
		}
	}
	if (badk>goodk || (!within(badk, goodk+badk, 66)))  
		mysprintf("\t- User can enable caching option.\n");
}

AnalyzeTables(data)
graphics_data *data;
{
	int i, j;
	int said=0;

	for (i=0; i<number_pseudos; i++) {
		TRANSACTION *t, *end_t;

		if (pseudo_table[i].type != TABLE) continue;
		if (!said) {
			mysprintf("*************************************\n");
			mysprintf("**** INFORMATION SHARING ANALYSIS ***\n");
			mysprintf("*************************************\n");
			said=1;
		}
		sprintf(temp_string, "Table %s: \n", pseudo_table[i].name);
		mysprintf(temp_string);
		InitHashKeys();
		this_table = i;

		for (j=data->begin_pe; j<=data->end_pe; j++) {
			/* t = transaction_table[j].head; */
			t = start_stage[j][data->begin_stages];
			end_t = start_stage[j][data->end_stages+1];

			while (t && t!=end_t) {
				TABLE_PROPERTY *temp;

				if (t->type==BEGIN_PROCESSING && t->info->table) 
					for (temp=t->info->table; temp!=NULL; temp=temp->next)
						if (temp->tbl== i) AddOperation(temp->type,
										j, temp->pe, temp->key);

				t = t->next;
			}
		}

		AreOperationsUnbalanced();
		IsLocalityPossible();
		/* IsCachingPossible(); */
		FreeHashKeys();
	}
}


