/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ldb.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:06:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ldb.c,v $
 * Revision 1.3  1995/09/21 21:06:13  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/ldb.c,v 1.3 1995/09/21 21:06:13 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "analyse.h"
#include "data.h"
#include "shared.h"

static int      mini;
static unsigned int mint;
static TRANSACTION *minptr, **points;

static unsigned int TIme;
static int      count_user, count_ldb;
static int      total_hops, total_new_chare;
static double   ratio, actual_dynamic, actual_static, possible, dop;


TRANSACTION    *
SkipToUser(t)
    TRANSACTION    *t;
{
    while (t && get_ep_index(t->info->ep, t->info->msg_type) == -1) {
	if (t->type == BEGIN_PROCESSING && t->info->msg_type == LdbMsg)
	    count_ldb++;
	t = t->next;
    }
    if (t && t->type == BEGIN_PROCESSING)
	count_user++;
    return t;
}


NewRatio(dop, ratio, TIme, actual_static, actual_dynamic, possible, new_time)
    double         *dop, *ratio;
    unsigned int   *TIme;
    double          actual_static, actual_dynamic, possible;
    unsigned int    new_time;
{
    double t1, t2;
	double actual = actual_static + actual_dynamic;

    t2 = (*dop) * (*TIme) + (actual + possible) * new_time;
    if (*TIme + new_time) *dop = t2 / (*TIme + new_time);

    t1 = 0.0;
    if (possible > number_pe-actual_static) possible = number_pe-actual_static;
    if (possible != 0.0) t1 = (actual_dynamic / possible);
    if (t1 == 0.0) return;

    t2 = (*ratio) * (*TIme) + t1 * new_time;
    if (*TIme + new_time) *ratio = t2 / (*TIme + new_time);

    *TIme += new_time;

}


/* determine new minimum */
static int
NewMinimum()
{
    int             i;

    minptr = NULL;
    mint = -1;
    for (i = 0; i < number_pe; i++) {
	if (points[i] && (GetTime(points[i]) < mint)) {
	    mint = GetTime(points[i]);
	    minptr = points[i];
	    mini = points[i]->pe;
	}
    }
}


int
EvaluateLdb()
{
    int             i;
    int             charminit_yes = 0;
    int             store_possible = 0;
    unsigned int    old_time;
    static int      error_message = 0;
    extern int      adjust_for_tachyon;

    TIme = 0;
    old_time = 0;
    count_user = count_ldb = 0;
    actual_static = actual_dynamic = dop = possible = ratio = 0.0;
    total_hops = total_new_chare = 0;

    mint = -1;

    points = (TRANSACTION **) malloc(sizeof(TRANSACTION *) * number_pe);
    for (i = 0; i < number_pe; i++) {
	points[i] = transaction_table[i].head;
	points[i] = SkipToUser(points[i]);
    }
    NewMinimum();

    while (minptr) {
	switch (minptr->type) {
	  case BEGIN_PROCESSING:
	    if (minptr->info->ep == charminit_id) {
		charminit_yes = 1;
		break;
	    }

	    NewRatio(&dop, &ratio, &TIme, actual_static, actual_dynamic, possible,
						mint - old_time);
	    if (minptr->info->msg_type == NewChareMsg) {
			int             c = 0;
			QUEUE_LIST     *q;

	    	actual_dynamic++;
			for (q = minptr->info->enqueue; q; q = q->next)
		    	c++;
			if (c == 1 && (minptr->pe != minptr->info->ptrc->pe))
		    	c++;
			total_hops += c - 1;
			total_new_chare++;

			possible--;
			if (possible < 0 && !error_message && !adjust_for_tachyon) {
		    	printf("ERROR: use +y option to remove tachyons.\n");
		    	error_message = 1;
			}
	    }
	    else actual_static++;
	    old_time = mint;
	    break;

	  case END_PROCESSING:
	    if (minptr->info->ep == charminit_id) {
		possible += store_possible;
		ratio = 0.0;
		store_possible = charminit_yes = TIme = 0;
		old_time = mint;
		break;
	    }

	    NewRatio(&dop, &ratio, &TIme, actual_static, actual_dynamic,
						possible, mint - old_time);
		if (minptr->info->msg_type == NewChareMsg) actual_dynamic--;
		else actual_static--;
	    old_time = mint;


	    break;

	  case CREATION:
	    if (minptr->info->ep == charminit_id)
		break;

	    if (minptr->info->msg_type == NewChareMsg) {
		if (charminit_yes)
		    store_possible++;
		else
		    possible++;
	    }
	    break;

	}
	points[mini] = SkipToUser(minptr->next);
	NewMinimum();
    }

    if (evaluate_ldb) {
	mysprintf("*****************************************\n");
	mysprintf("**** LOAD BALANCING STRATEGY ANALYSIS ***\n");
	mysprintf("*****************************************\n");

	sprintf(temp_string,
		"Actual parallelism/Max. possible parallelism = %f\n",
		ratio);
	mysprintf(temp_string);
	if (count_user)
	    sprintf(temp_string, "Number of LDB msg/Number of user msg = %f\n",
		    ((float) count_ldb) / ((float) count_user));
	mysprintf(temp_string);

	if (total_new_chare)
	    sprintf(temp_string,
		    "Average no. of hops for each new chare = %f\n",
		    ((float) total_hops) / ((float) total_new_chare));
	mysprintf(temp_string);
    }

    mysprintf("*****************************************\n");
    mysprintf("****    PARALLELISM ANALYSIS          ***\n");
    mysprintf("*****************************************\n");
    sprintf(temp_string, "Average degree of parallelism = %f\n", dop);
    mysprintf(temp_string);
    if (2 * dop < number_pe) {
	mysprintf("Your program does not have sufficient parallelism\n");
	mysprintf("Therefore it does not effectively utilize the overlap\n");
	mysprintf("capabilities of Charm. Try splitting tasks into smaller\n");
	mysprintf("subtasks.\n");
    }

    free(points);
}
