/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: data.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:06:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: data.c,v $
 * Revision 1.3  1995/09/21 21:06:13  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:35  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/analyse/data.c,v 1.3 1995/09/21 21:06:13 sanjeev Exp $";
#include <stdio.h>
#include "common.h"
#include "analyse.h"
#define DATA
#include "data.h"
#undef DATA


/*****************************************************************/
/** Find out times of various events **/
/*****************************************************************/
unsigned int GetTime(t)
TRANSACTION *t;
{
	QUEUE_LIST *q;

	if (t==NULL) return 0;
	switch (t->type) {
	case CREATION:
		return t->info->timec; 
	case ENQUEUE:
		q = t->info->enqueue;
		while (q != NULL)
		{
			if (q->ptr == t)
				return q->time;
			q = q->next;
		}
		break;
	case DEQUEUE:
		q = t->info->dequeue;
		while (q != NULL)
		{
			if (q->ptr == t)
				return q->time;
			q = q->next;
		}
		break;
	case BEGIN_PROCESSING:
		return t->info->timep1; 
	case END_PROCESSING:
		return t->info->timep2; 
	case END_INTERRUPT:
		return t->info->timep1; 
	default:
		printf("*** ERROR *** Can't find time for unknown transaction %d\n",
					t->type);
	}
	return 0;
}


/*****************************************************************/
/** Add stage index into current list.							**/
/*****************************************************************/
AddStagePtr(pe, time1, t)
int pe;
unsigned int time1; 
TRANSACTION *t;
{
	int current_stage = INTERVAL(time1);
	
	if (start_stage[pe][current_stage] == NULL) {
		int i;
		start_stage[pe][current_stage] = t;
		for (i=current_stage-1; i>=previous_stage; i--)
			start_stage[pe][i] = start_stage[pe][current_stage];
		previous_stage = current_stage+1;
	}
}

/*****************************************************************/
/** Add additional entry for table requests.					**/
/*****************************************************************/
AddAdditionalTable(type, node, tbl, key, pe)
int type;
NODE *node;
int tbl, key, pe;
{
	TABLE_PROPERTY *temp = (TABLE_PROPERTY *)
									 malloc(sizeof(TABLE_PROPERTY));
	temp->type = type;
	temp->tbl = tbl;
	temp->key = key;
	temp->pe = pe;
	temp->next = node->table;
	node->table = temp;
/* printf("AddAdditional: type=%d, tbl=%d, key=%d\n", type, tbl, key); */ 
}

/*****************************************************************/
/** Create the information entry about the message, and add a 	**/
/** transaction to the list of transactions.					**/
/*****************************************************************/
NODE *BuildNode(pe, event, ep, msg_type)
int pe, event, ep, msg_type;
{
	NODE  *n  =  (NODE *) malloc(sizeof(NODE));
	check_memory("BuildNode", n);
	n->tag = -1;
	n->pe = pe;
	n->event = event;
	n->ep = ep;
	n->msg_type = msg_type;
	n->creator = NULL;
	n->ptrc = n->ptrp1 = n->ptrp2 = NULL;
	n->enqueue = n->dequeue = NULL;
	n->creation_list = NULL;
	n->table = NULL;
	n->dop = 0;

/* printf("BuildNode: pe=%d, event=%d, ep=%d, type=%d\n", pe, event, ep,
msg_type); */
	HashInsert(pe, event, n);
	return n;
}

CompleteNode(n, ep, msg_type)
NODE *n;
int ep, msg_type;
{
	if (n->ep != -1) return;
	n->ep = ep;
	n->msg_type = msg_type;
}


NODE *AddTransaction(mype, pe, event, ep, msg_type, transaction_type, 
						time1)
int mype, pe, event, ep, msg_type, transaction_type;
unsigned int time1;
{
	QUEUE_LIST *q;
	NODE * n = HashFind(pe, event);
	TRANSACTION * t = (TRANSACTION *) malloc(sizeof(TRANSACTION));

/* printf("AddTransaction: pe=%d, event=%d, transaction=%d, time1=%d\n",
pe, event, transaction_type, time1); */
	
	check_memory("AddTransaction", t);
	if (n == NULL)
		n = BuildNode(pe, event, ep, msg_type);

	t->queue = queue_size;
	t->info = n;
	t->type = transaction_type;
	t->pe = mype;
	t->next = NULL;
	if (transaction_table[mype].head == NULL)
	{
		transaction_table[mype].head = t; 
		t->previous = NULL;
	}
	else
	{
		transaction_table[mype].tail->next = t;
		t->previous = transaction_table[mype].tail;
	}
	transaction_table[mype].tail = t;

	switch (transaction_type) {
	case CREATION:
		n->timec = time1;
		n->ptrc = t;
		CompleteNode(n, ep, msg_type);
		if (current_node) {
			TRANSACTION_LIST *tl = (TRANSACTION_LIST *)
										malloc(sizeof(TRANSACTION_LIST));
			n->creator = current_node->ptrp1;

			tl->ptr = t;
			tl->previous = NULL;
			tl->next = current_node->creation_list;
			if (current_node->creation_list)
				current_node->creation_list->previous = tl;
			current_node->creation_list = tl;
		}
		break;

	case ENQUEUE:
		q = (QUEUE_LIST *) malloc(sizeof(QUEUE_LIST));;
		check_memory("AddTransaction", q);
		q->time = time1;
		q->ptr = t;
		q->next = n->enqueue;
		n->enqueue = q;
		break;

	case DEQUEUE:
		q = (QUEUE_LIST *) malloc(sizeof(QUEUE_LIST));;
		check_memory("AddTransaction", q);
		q->time = time1;
		q->ptr = t;
		q->next = n->dequeue;
		n->dequeue = q;
		break;

	case BEGIN_PROCESSING:
		n->timep1 = time1;
		n->ptrp1 = t;
		CompleteNode(n, ep, msg_type);
		break;
		
	case END_PROCESSING:
		n->timep2 = time1;
		n->ptrp2 = t;
		break;

	case BEGIN_INTERRUPT:
		n->timep1 = time1;
		n->ptrp1 = t;
		break;

	case END_INTERRUPT:
		n->timep2 = time1;
		n->ptrp2 = t;
		break;
	}
	AddStagePtr(mype, time1, t);
	return n;
}


/*****************************************************************/
/** The functions that follow relate to the hash table			**/
/*****************************************************************/


HashInsert(pe, event, ptr)
int pe, event;
NODE *ptr;
{
	int index = HashMap(pe, event);

/* printf("HashInsert: pe=%d, event=%d, index=%d, ptr=0x%x\n",
pe, event, index, ptr); */
	ptr->next = hash_table[index];
	hash_table[index] = ptr;
}


HashDelete(pe, event)
int pe, event;
{
	NODE *current, *previous;
	int index = HashMap(pe, event);

	previous =  current = hash_table[index];
	if (current != NULL)
	{
		if (HashEqual(current, pe, event))
		{
			hash_table[index] = current->next;
			free(current);
			return;
		}

		current = current->next;
		while (current != NULL)
		{
			if (HashEqual(current, pe, event))
			{
				previous->next = current->next;
				free(current);
				return;
			}
			current = current->next;
			previous = previous->next;
		}
	}
	printf("*** ERROR *** PTR_INFO not found in hash table %d.\n", index);
}


NODE * HashFind(pe, event)
int pe, event;
{
	NODE *current;
	int index = HashMap(pe, event);

/* printf("HashFind: pe=%d, event=%d, index=%d\n", pe, event, index); */
	current = hash_table[index];
	while (current != NULL)
		if (HashEqual(current, pe, event))
			return current;
		else
			current = current->next;
	return NULL;
}


/*****************************************************************/
/** Functions to search the transaction_line to determine 		**/
/** entries.													**/
/*****************************************************************/
TRANSACTION *find_lesser(pe, t)
int pe;
unsigned int t;
{
    int i;
	int current_stage = INTERVAL(t);
	TRANSACTION  * current = start_stage[pe][current_stage];

	if (current == NULL) return NULL;

	if (GetTime(current) > t) return current;
	while ((current->next!=NULL)  && (GetTime(current)<=t))
	{	
        if (GetTime(current->next) > t) return current;
		current = current->next;
    }
    if (GetTime(transaction_table[pe].tail) <= t) 
		return transaction_table[pe].tail;
    return NULL;
}

TRANSACTION *find_greater(pe, t)
int pe;
unsigned int t;
{
    int i;
	int current_stage = INTERVAL(t);
	TRANSACTION * current = start_stage[pe][current_stage];

	if (current == NULL) return current;

	if (GetTime(current) > t) return current;
	while ((current->next!=NULL)  && (GetTime(current)<=t))
	{	
        if (GetTime(current->next) > t) return current->next;
		current = current->next;
    }
    if (GetTime(current) >= t) return current;
	return NULL;
}


/*****************************************************************/
/* Get the previous element. It is slightly inaccurate.			**/
/*****************************************************************/

TRANSACTION *GetPrevious(t)
TRANSACTION *t;
{
	QUEUE_LIST *q;

	if (t==NULL) return;
	switch (t->type) {
	case CREATION:
		return t->info->creator;

	case ENQUEUE:
		return t->info->ptrc;

	case DEQUEUE:
		for (q=t->info->enqueue; q; q = q->next)
			if (q->ptr->pe == t->pe) return q->ptr;
		return NULL;

	case BEGIN_PROCESSING:
		for (q=t->info->dequeue; q; q = q->next)
			if (q->ptr->pe == t->pe) return q->ptr;
		return t->info->ptrc;

	case END_PROCESSING:
		return t->info->ptrp1;

	default:
		printf("*** ERROR *** Can't find type for unknown transaction %d\n",
					t->type);
	}
}


mysprintf(s)
char *s;
{
    char *save_string = my_string;
    my_string = (char *) malloc(strlen(my_string) + strlen(s) + 1);
    strcpy(my_string, save_string);
    strcat(my_string, s);
    free(save_string);
}


_add_to_string(s)
char *s;
{
    char *save_string = store_string;
    store_string = (char *) malloc(strlen(store_string) + strlen(s) + 1);
    strcpy(store_string, save_string);
    strcat(store_string, s);
    free(save_string);
}


RecomputeEndTime(et)
unsigned int *et;
{
	int i;
	*et = 0;
	for (i=0; i<number_pe; i++)
		if (GetTime(transaction_table[i].tail) > *et)
			*et = GetTime(transaction_table[i].tail); 
}
