// Hey emacs, this is -*- C++ -*-

#ifndef _fam_h_
#define _fam_h_

/************************************************************************/
/*									*/
/*	Nth Fibonocci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/

#include "messages.h"
#include "megatest++.h"
#include "generic_class.h"
#include "fib.h"

#define N 20

/************************************************************/

message class fam_MSG1 {
public:     int	fibNum;
     int 	level;
     ChareIDType parentID;
};

message class fam_MSGUP {
public:     int 	rspData;
};

message class fam_MSG_LEVEL {
public:     int 	counter[N];
};

/************************************************************/

accumulator class ACC1 {

     fam_MSGUP *msg;
     
  public:
     ACC1(fam_MSGUP *data); 
     
     void Accumulate ();
     
     void Combine (fam_MSGUP *y);
     
};

accumulator class ACC2 {
     
     fam_MSG_LEVEL *msg;
     
  public:
     ACC2 (fam_MSGUP *data);
     
     void Accumulate (int y);
     
     void Combine (fam_MSG_LEVEL *y);
     
};

monotonic class MONO1 {
     
     fam_MSGUP *msg;
     
  public:
     MONO1 (fam_MSGUP *data);
     
     int Update (fam_MSGUP *y);

};

extern void fam_initfn();

/* In fam.P
readonly int fam_topFib, fam_grainSize;
readonly ACC1 handle fam_acc1id;
readonly ACC2 handle fam_acc2id;
readonly MONO1 handle fam_mono1id;
*/

/* ****************************************** */
chare class fam_start : public generic_class {

  private:
     INIT_MSG *store;

  entry:

     fam_start (INIT_MSG *imsg);

     void Quiescence (QuiescenceMessage *msg);

     void  MAINEP1 (fam_MSGUP *m);

     void MAINEP2 (fam_MSG_LEVEL *msg);

     void MAINEP3 (fam_MSGUP *msg);

};

chare class fam_fib {

  private:
     int	isFinal;
     int	fibNum;
     int	rspNum;
     int	rspData;
     ChareIDType parentID;
     
  entry:

     fam_fib (fam_MSG1 *msg1P);

     void RESPONSE (fam_MSGUP *msg2P);

};


extern void fam_ProcessResult(int, ChareIDType *, int, fam_MSGUP *);


#endif

