/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.p,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.0 $	$Date: 1995/06/01 21:08:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.p,v $
 * Revision 2.0  1995/06/01 21:08:52  brunner
 * Reorganized directory structure
 *
 * Revision 1.1  1994/10/14  21:43:42  brunner
 * Initial revision
 *
 ***************************************************************************/

module Primes {

#define IsSet(a,ind)  ( (a[(ind/32)]) & (1<<(ind % 32)) )
#define IsReset(a,ind)  !( (a[(ind/32)]) & (1<<(ind % 32)) )
#define Set(a,ind) a[(ind/32)] = ( a[(ind/32)] | (1<<(ind % 32)) )
#define Reset(a,ind) a[(ind/32)] = ( a[(ind/32)] & (~(1<<(ind % 32))) )

/* #define LENGTH 30030 */
/* #define LENGTH 2310 */
#define LENGTH 210
#define PREMARK 4

readonly int grain;
readonly int primes[1300], primeSquares[1300];
readonly int template[(LENGTH)/(2*32) + 1], numStoredPrimes;
readonly int total;

message {
	int n;
} NMSG;

message {
        int     data;
} MSG_ACC_COUNT;

accumulator {

        MSG_ACC_COUNT *msg;

        MSG_ACC_COUNT *initfn(x)
        MSG_ACC_COUNT *x;
        {
                msg = (MSG_ACC_COUNT *) CkAllocMsg(MSG_ACC_COUNT);
                msg->data = 0;
                return(msg);
        }

        addfn (x)
		int x;
        {
                msg->data += x;
        }

        combinefn (y)
        MSG_ACC_COUNT *y;
        {
                msg->data += y->data;
        }
}  ACC_COUNT;


message {int L; int H;} goalMsg;

chare main {
  int n, next, isPrime;
  int count;
  int Limit;

entry CharmInit: {
  int g;
int flag;
int i,j;
int l2;
  goalMsg * msg;
  ChareIDType mainid;
MSG_ACC_COUNT *acc_msg;

  CPrintf("Enter upper limit: ");
  CScanf("%d", &Limit);
  CPrintf("Enter grain-size: ");
  CScanf("%d", &grain);

  primes[1] = 2;       primes[2] = 3;
  primeSquares[1] = 4; primeSquares[2] = 9;
  next = 3;
  flag = 0;
  for (n=5; (1==1); n+=2)
    {
      if (n*n > Limit) flag = 1; /* stop after the next prime is found */
      isPrime = 1;
      for (i=2;  (isPrime && primeSquares[i] <= n); i++)
	{ if ( (n % primes[i]) == 0) isPrime = 0;}
      if (isPrime)
	{ primes[next] = n;
	  primeSquares[next] = n*n;
	  next++;
	  if (flag) break;
	}
    }
  numStoredPrimes = next-1;

  ReadInit(grain);
  ReadInit(primes);
  ReadInit(primeSquares);
  ReadInit(numStoredPrimes);
 
  /* mark multiples of 3,5,7,and 11 (i.e. primes[2] ..primes[PREMARK]).*/
  /*  bits go from 0 .. LENGTH - 1 */
  l2 = LENGTH/2;
  for (i=2; i<=PREMARK; i++)
    for (j = (primes[i]-1)/2; j<l2; j+= primes[i])
      Set(template, j);
  ReadInit(template);

	acc_msg = (MSG_ACC_COUNT *) CkAllocMsg(MSG_ACC_COUNT);
  acc_msg->data = 0;
  total = CreateAcc(ACC_COUNT, acc_msg);
  ReadInit(total);

  msg = (goalMsg *) CkAllocMsg(goalMsg);
  msg->L = 1;
  msg->H = Limit;
  CreateChare(sieve, sieve@Goal, msg);

  MyChareID(&mainid);
  StartQuiescence(Quiescence1, &mainid);
}

entry Quiescence1: (message NMSG *m) {
  ChareIDType CID;
  MyChareID(&(CID));
  CollectValue(total, main@MAIN_RESULT, &(CID));
}

entry MAIN_RESULT: (message MSG_ACC_COUNT * result)
  { CPrintf("The # of primes in the range 2:%d is: %d. \nTime = %f msec\n",
	     Limit, result->data + 1, CmiTimer());
    /* adding 1 for "2" being even */
    CkExit();
  }

}


chare sieve 
{
     int L;
     int H;
     int count;

 entry Goal: (message goalMsg * msg1)
  { goalMsg * msg2;
    int Mid;
    static int seqSieve();

    L = msg1->L; H = msg1->H;
    /* L-1 is always a multiple of Lenght */
    if (( (L-1) % LENGTH) != 0) 
      CPrintf("ERROR: L=%d,H=%d LENGTH=%d, remainder=%D\n", L, H, LENGTH, L % LENGTH);
				  
    if ((H-L+1) > grain*LENGTH) 
      { Mid = (H-L+1)/(2*LENGTH);
	if (Mid == 0) Mid++;
	Mid =  L + LENGTH*Mid;
	msg2 = (goalMsg *) CkAllocMsg( goalMsg);
	msg2->L = Mid; msg2->H = H;
	msg1->H = Mid-1; /* msg1->L == L already */
	CreateChare(sieve, sieve@Goal, msg1);
	CreateChare(sieve, sieve@Goal, msg2);
      }
    else { /* H-L+1 == grain*LENGTH in all cases, except at the high end, where H-L+1 
	      may be less than LENGTH */
      int i, l, h;
      count = 0;
      for (l=L; l<H; l+=LENGTH) {
	h = l+LENGTH-1;
	if (h>H) h = H;
	count += seqSieve(l,h);
      }
      CkFreeMsg(msg1);
      PrivateCall(sendResponse(count));}
  ChareExit();
  }

 private sendResponse(value)
   int value;
     { Accumulate(total, addfn(value)); 
     }
}

int seqSieve(L,H)
     int L;
     int H;
{  
  int  count;
  int i,j,k,prime;
  int length, startFrom;
  int m, sqr;
  int bitVector[LENGTH/64 + 1];

 if ((L % 2) == 0) L++;

  for (i=0; i<((LENGTH/64) + 1); i++) bitVector[i] = ReadValue(template[i]);

  if (L == 1)
    { /* correct for the template not being right for this boundary case */
      Set(bitVector, 0); /* 1 is not counted as a prime */
      for (i=2; i<=PREMARK; i++)
	Reset(bitVector, (ReadValue(primes[i]) - 1)/2);
  }
  /* length should have the total number of "active" bits. 
     if H is odd, (11-15 -> 3 [11, 13, 15])  (H-L)/2 +1
     if H is even:  (H-L)/2 + 1 (as in 11-16 -> [11,13,15] )
   */
  length = (H-L)/2+1; 

/* bitVector has only odd numbers now, beginning with L.
   number k is represented by the bit at index (k-L)/2.
   conversely, i'th bit represents the number L+2*i.  0'th bit has L */

/*  begin marking multiples with the (PREMARK+1)'th prime. Others 
    (i.e. 3,5,..primes[PREMARK]) have been pre-marked  in the template itself. */
 
  k = PREMARK+1;
  while (( ReadValue(primes[k]) * ReadValue(primes[k]) ) <= H) 
    k++;

 for (i=PREMARK+1; i <k; i++)
   { prime = ReadValue(primes[i]);
     sqr = prime*prime;

     /* mark the multiples of prime in the bit-vector.*/
     /* multiples less than prime*prime are already ruled out by smaller primes */

     /* startFrom = the first odd value >= L, and >= prime*prime, 
	that is a multiple of prime. */

     if (sqr > L) startFrom = sqr;
     else if ((L % prime) == 0) startFrom = L;
     else { m = L/prime; 
	    if ((m % 2 == 0)) m++; else m += 2;
	    startFrom = m*prime;}

     for (j = (startFrom - L)/2; j <= length; j+=prime)
	 Set(bitVector, j); 
   }

  count = 0;
  /* i'th bit corresponds to the number 2*i+1 */
/*  for (i=0; i<length; i++)
      if (IsReset(bitVector, i))
	{CPrintf("%d\t", L+2*i);}
*/

/* Set the (unused) trailing bits to 1, so they don't get counted as primes */
  for (i=length; i < 32*((LENGTH/64) + 1); i++)
    Set(bitVector, i);  

  for (i=0; i<((LENGTH/64) + 1); i++) 
    { int b, c;
      b = bitVector[i];
      c = 32;
      while (b) {
	c--;
	b = b & (b-1);
      }
      count += c;
    }


  /* Instead of counting them, send the bitvector itself to the file system
     or to the main chare, if actual prime-list is required to be output */

return(count);
}
     

}
