#ifndef _pgl_P_
#define _pgl_P_

#include "pgl.h"

// From node_ck.c
extern "C" SetRefNumber(void *, int);
extern "C" GetRefNumber(void *);

readonly ChareNumType pgcoord;

/************************************************************/

void pgl_initfn() {

     pgcoord = CreateRootGroup();
     ReadInit(pgcoord);

}

/************************************************************/

void 
pgl_TestBoc::start (pgl_START_MESSAGE *inMsg) {

     coordBoc = inMsg->pgCoord ;
     me = CMyPeNum() ;
     myBocNum = thisgroup ;
     myBocID = thishandle ;
     gotBack = 0 ;
     
     iteration = inMsg->iteration;
     retEP = inMsg->retEP;
     retID = inMsg->retID;
     
     if (me < CMaxPeNum()/2) 
	  lower = 1 ;
     else 
	  lower = 0 ;
     
     if (me % 2 == 0) 
	  odd = 0 ;
     else 
	  odd = 1 ;
     
     Partition(coordBoc, 0, 0, 0, lower, &(pgl_TestBoc::LowerUpperPart),
	       myBocNum) ;
     CStartQuiescence(&(pgl_TestBoc::qdetect), thishandle);
     delete inMsg ;
     
} /* end entry start */

void 
pgl_TestBoc::LowerUpperPart (PARTITION_CREATED *inMsg) {

     int luGid ;
     pgl_TEST_MESSAGE *outMsg ;

     luGid = inMsg->newGid ;
     
     Partition(coordBoc, luGid, 0, odd, 0, &(pgl_TestBoc::OddEvenPart),
	       myBocNum) ;
     delete inMsg ;

}

void 
pgl_TestBoc::OddEvenPart (PARTITION_CREATED *inMsg) {

     int i, totalSize ;
     pgl_TEST_MESSAGE *outMsg1 ;
     pgl_VARSIZE_MESSAGE *vMsg ;
     
     finalGid = inMsg->newGid ;
     totalSize = 10 ;
     outMsg1 = new pgl_TEST_MESSAGE  ;
     vMsg = new (&totalSize) pgl_VARSIZE_MESSAGE; 

     for(i=0;i<10;i++) {
	  vMsg->tenStuff[i] = i+100 ;
     }

     // ???
     SetRefNumber(outMsg1, me) ;
     SetRefNumber(vMsg, 1);	
     // ???

     if (odd) 
	  strcpy(outMsg1->evenodd, "odd") ;
     else 
	  strcpy(outMsg1->evenodd, "even") ;
     
     if (lower) 
	  strcpy(outMsg1->lowup, "lower") ;
     else 
	  strcpy(outMsg1->lowup, "upper") ;
     
     Multicast(coordBoc,finalGid,outMsg1,&(pgl_TestBoc::deliverEp),myBocNum) ;
     Multicast(coordBoc,finalGid,vMsg,&(pgl_TestBoc::varsizeEp),myBocNum) ;
     delete inMsg ;
}


void 
pgl_TestBoc::deliverEp (pgl_TEST_MESSAGE *msg) {

     int ref, i ;
     pgl_TEST_MESSAGE2 *msg2 ;

     // ???
     ref = GetRefNumber(msg) ;
     CPrintf("PGL:**** I am NODE %d and I am %s and %s, as is my sender %d?\n",
	     me, msg->lowup, msg->evenodd,ref) ;
     
     msg2 = new pgl_TEST_MESSAGE2  ;
     msg2->sender = me ;
     delete msg ;
}

void 
pgl_TestBoc::varsizeEp (pgl_VARSIZE_MESSAGE *vMsg) {

     int i ;

     CPrintf("PGL:Got varsize message - 10 ints\n") ;
     for(i=0;i<10;i++) {
	  CPrintf("PGL:%d ",vMsg->tenStuff[i]) ;
     }
     CPrintf("PGL:\n") ;
     delete vMsg ;

}

void 
pgl_TestBoc::qdetect (QuiescenceMessage *qmsg) {

     if(me==0) {
	  CPrintf("PGL:Quiescence detected\n") ;
     }

     Synchronize(coordBoc, finalGid, 49, (GENERIC_MESSAGE *)qmsg,
		 &(pgl_TestBoc::groupSync),
		 myBocID) ;
}

void 
pgl_TestBoc::groupSync (QuiescenceMessage *qmsg) {

     CPrintf("PGL:Group %d on pe %d has syncronized.\n",finalGid,me) ;
     Synchronize(coordBoc, 0, 50, (GENERIC_MESSAGE *)qmsg,
		 &(pgl_TestBoc::allSync), myBocID) ;

}

void 
pgl_TestBoc::allSync (QuiescenceMessage *qmsg) {

     IT_MSG *imsg;

     if(me==0) {
	  CPrintf("PGL:All processors (group 0) have synchronized... exiting.\n") ;
	  imsg = new IT_MSG ;
	  imsg->iteration = iteration;
	  
	  generic_class handle h = retID;
	  EntryPointType ep = retEP;
	  h=>ep(imsg);
//	  SendMsg(retEP, imsg, &retID);

	  delete qmsg ;
     }

}

/************************************************************/

void 
pgl_start::pgl_start (INIT_MSG *imsg) {

     ChareIDType myid;
     pgl_START_MESSAGE *startMsg ;
     
     myid = thishandle;
     
     iteration = imsg->iteration;
     retEP = imsg->retEP;
     retID = imsg->retID;
     pgCoord = pgcoord;

     startMsg = new pgl_START_MESSAGE  ;
     startMsg->pgCoord = pgCoord ;
     startMsg->iteration = iteration;
     startMsg->retEP = retEP;
     startMsg->retID = retID;

     newchare ( &(pgl_start::bocCreated), &myid) pgl_TestBoc(startMsg) ;
//     CreateBoc(TestBoc, TestBoc@start, startMsg, bocCreated, &myid) ;
     delete imsg ;

}

void 
pgl_start::bocCreated (GroupIdMessage *msg) {

     delete msg ;

}

#endif
