#include <stdio.h>
#include "charm++.h"

#include "schedtest.top.h"
#include "schedtest.h"

main::main(int argc, char**argv)
{        
  InitMsg *msg = new (MsgIndex(InitMsg)) InitMsg;
  new_chare(test, InitMsg, msg);
}

test::test(InitMsg *msg)
{
  msg_count = 0;
  starttimer = CTimer();
  CSendMsg(test, process, InitMsg,msg, &thishandle);
}

void test::process(InitMsg *msg)
{
  msg_count++;
  if(msg_count == NMSG) {
    endtimer = CTimer();
    timeTaken1 = (endtimer-starttimer)/1000.0;
    msg_count = 0;
    starttimer = CTimer();
    CSendMsg(test, process_t, InitMsg,msg, &thishandle);
  } else {
    CSendMsg(test, process, InitMsg,msg, &thishandle);
  }
}

void test::process_t(InitMsg *msg)
{
  msg_count++;
  if(msg_count == NMSG) {
    endtimer = CTimer();
    timeTaken2 = (endtimer-starttimer)/1000.0;
    CPrintf("Scheduling Overhead:\n");
    CPrintf("\tNon-Threaded:\t%lf microseconds\n",(timeTaken1/NMSG)*(1.0e6));
    CPrintf("\tThreaded    :\t%lf microseconds\n",(timeTaken2/NMSG)*(1.0e6));
    CharmExit();
  } else {
    CSendMsg(test, process_t, InitMsg,msg, &thishandle);
  }
}

#include "schedtest.bot.h"
