#include <time.h>

typedef struct timeval TIMEVAL;
typedef struct timezone TIMEZONE;

#define NUM_TRIALS 20

#ifdef NETWORK_VERSION
extern int NumRetransmits;
#else
int NumRetransmits=0;
#endif

message class InitMsg {
  int x;
} ;

message class sizeZeroMsg {
public:
  int trial_num;
} ;

message class size100Msg {
public:
  int trial_num;
  int data[25];
} ;
message class size1000Msg {
public:
  int trial_num;
  int data[250];
} ;

message class size10000Msg {
public:
  int trial_num;
  int data[2500];
} ;
message class size100000Msg {
public:
  int trial_num;
  int data[25000];
} ;
message class size1000000Msg {
public:
  int trial_num;
  int data[250000];
} ;

chare class PingPong : public groupmember
{
  TIMEVAL t1, t2;
  TIMEZONE tz;
  unsigned long total_time;

entry:
  void SendSizeZeroMsg(sizeZeroMsg *msg)
  {
    unsigned long dt;

    gettimeofday(&t2,&tz);
    
    if (msg->trial_num==-1) {
      CPrintf("Zero message\n");
      total_time=0;
    } else {
      dt = (t2.tv_sec-t1.tv_sec)*1000000 + t2.tv_usec - t1.tv_usec;
      CPrintf("SIZE 0   TRIAL %d    %8d   %8d\n",msg->trial_num,dt,NumRetransmits);
    
      total_time+=dt;
    }

    if (msg->trial_num == NUM_TRIALS-1)
      {
	CPrintf("Total Round-trip time = %8ld\n",total_time);
	CPrintf("Avgerage Round-trip time = %8f\n\n",
		(float)total_time/NUM_TRIALS);
	
	delete msg;
	AllDone(0);
      } 
    else
      {
	msg->trial_num++;
	gettimeofday(&t1,&tz);
	thisgroup[1]=>ReturnSizeZeroMsg(msg);
      }
  }

  void ReturnSizeZeroMsg(sizeZeroMsg *msg)
  {
    thisgroup[0]=>SendSizeZeroMsg(msg);
  }

  void SendSize100Msg(size100Msg *msg)
  {
    unsigned long dt;

    gettimeofday(&t2,&tz);

    if (msg->trial_num==-1) {
      CPrintf("Size 100 message\n");
      total_time=0;
    } else {
      dt = (t2.tv_sec-t1.tv_sec)*1000000 + t2.tv_usec - t1.tv_usec;
      CPrintf("SIZE 100   TRIAL %d    %8d   %8d\n",msg->trial_num,dt,NumRetransmits);
      total_time+=dt;
    }

    if (msg->trial_num == NUM_TRIALS-1)
      {
	CPrintf("Total Round-trip time = %8ld\n",total_time);
	CPrintf("Avgerage Round-trip time = %8f\n\n",
		(float)total_time/NUM_TRIALS);
	
	delete msg;
	AllDone(100);
      } 
    else
      {
	msg->trial_num++;
	gettimeofday(&t1,&tz);
	thisgroup[1]=>ReturnSize100Msg(msg);
      }
  }

  void ReturnSize100Msg(size100Msg *msg)
  {
    thisgroup[0]=>SendSize100Msg(msg);
  }

  void SendSize1000Msg(size1000Msg *msg)
  {
    unsigned long dt;

    gettimeofday(&t2,&tz);

    if (msg->trial_num==-1) {
      CPrintf("Size 1000 message\n");
      total_time=0;
    } else {
      dt = (t2.tv_sec-t1.tv_sec)*1000000 + t2.tv_usec - t1.tv_usec;
      CPrintf("SIZE 1000   TRIAL %d    %8d   %8d\n",msg->trial_num,dt,NumRetransmits);
      total_time+=dt;
    }

    if (msg->trial_num == NUM_TRIALS-1)
      {
	CPrintf("Total Round-trip time = %8ld\n",total_time);
	CPrintf("Avgerage Round-trip time = %8f\n\n",
		(float)total_time/NUM_TRIALS);
	
	delete msg;
	AllDone(1000);
      } 
    else
      {
	msg->trial_num++;
	gettimeofday(&t1,&tz);
	thisgroup[1]=>ReturnSize1000Msg(msg);
      }
  }

  void ReturnSize1000Msg(size1000Msg *msg)
  {
    thisgroup[0]=>SendSize1000Msg(msg);
  }

  void SendSize10000Msg(size10000Msg *msg)
  {
    unsigned long dt;

    gettimeofday(&t2,&tz);

    if (msg->trial_num==-1) {
      CPrintf("Size 10000 message\n");
      total_time=0;
    } else {
      dt = (t2.tv_sec-t1.tv_sec)*1000000 + t2.tv_usec - t1.tv_usec;
      CPrintf("SIZE 10000   TRIAL %d    %8d   %8d\n",msg->trial_num,dt,NumRetransmits);
      total_time+=dt;
    }
    
    if (msg->trial_num == NUM_TRIALS-1)
      {
	CPrintf("Total Round-trip time = %8ld\n",total_time);
	CPrintf("Avgerage Round-trip time = %8f\n\n",
		(float)total_time/NUM_TRIALS);
	
	delete msg;
	AllDone(10000);
      } 
    else
      {
	msg->trial_num++;
	gettimeofday(&t1,&tz);
	thisgroup[1]=>ReturnSize10000Msg(msg);
      }
  }

  void ReturnSize10000Msg(size10000Msg *msg)
  {
    thisgroup[0]=>SendSize10000Msg(msg);
  }

  void SendSize100000Msg(size100000Msg *msg)
  {
    unsigned long dt;

    gettimeofday(&t2,&tz);

    if (msg->trial_num==-1) {
      CPrintf("Size 100000 message\n");
      total_time=0;
    } else {
      dt = (t2.tv_sec-t1.tv_sec)*1000000 + t2.tv_usec - t1.tv_usec;
      CPrintf("SIZE 100000   TRIAL %d    %8d   %8d\n",msg->trial_num,dt,NumRetransmits);
      total_time+=dt;
    }

    if (msg->trial_num == NUM_TRIALS-1)
      {
	CPrintf("Total Round-trip time = %8ld\n",total_time);
	CPrintf("Avgerage Round-trip time = %8f\n\n",
		(float)total_time/NUM_TRIALS);
	
	delete msg;
	AllDone(100000);
      } 
    else
      {
	msg->trial_num++;
	gettimeofday(&t1,&tz);
	thisgroup[1]=>ReturnSize100000Msg(msg);
      }
  }

  void ReturnSize100000Msg(size100000Msg *msg)
  {
    thisgroup[0]=>SendSize100000Msg(msg);
  }

  void SendSize1000000Msg(size1000000Msg *msg)
  {
    unsigned long dt;

    gettimeofday(&t2,&tz);

    if (msg->trial_num==-1) {
      CPrintf("Size 1000000 message\n");
      total_time=0;
    } else {
      dt = (t2.tv_sec-t1.tv_sec)*1000000 + t2.tv_usec - t1.tv_usec;
      CPrintf("SIZE 1000000   TRIAL %d    %8d   %8d\n",msg->trial_num,dt,NumRetransmits);
      total_time+=dt;
    }

    if (msg->trial_num == NUM_TRIALS-1)
      {
	CPrintf("Total Round-trip time = %8ld\n",total_time);
	CPrintf("Avgerage Round-trip time = %8f\n\n",
		(float)total_time/NUM_TRIALS);
	
	delete msg;
	AllDone(1000000);
      } 
    else
      {
	msg->trial_num++;
	gettimeofday(&t1,&tz);
	thisgroup[1]=>ReturnSize1000000Msg(msg);
      }
  }

  void ReturnSize1000000Msg(size1000000Msg *msg)
  {
    thisgroup[0]=>SendSize1000000Msg(msg);
  }


  PingPong(InitMsg *msg)
  {
    if ( CMyPeNum() == 0 ) {
      sizeZeroMsg *sendmsg = new sizeZeroMsg;
      
      sendmsg->trial_num=-1;
      thisgroup[CMyPeNum()]=>SendSizeZeroMsg(sendmsg) ;
    }

    delete msg;
  }

public:
  void AllDone(int i_num) 
  {
    if (CMyPeNum() == 0)  {
      if (i_num==0)
	{
	  size100Msg *sendmsg = new size100Msg;

	  sendmsg->trial_num=-1;
	  thisgroup[0]=>SendSize100Msg(sendmsg);
	}
      else if (i_num==100)
	{
	  size1000Msg *sendmsg = new size1000Msg;

	  sendmsg->trial_num=-1;
	  thisgroup[0]=>SendSize1000Msg(sendmsg);
	}
      else if (i_num==1000)
	{
	  size10000Msg *sendmsg = new size10000Msg;

	  sendmsg->trial_num=-1;
	  thisgroup[0]=>SendSize10000Msg(sendmsg);
	}
      else if (i_num==10000)
	{
	  size100000Msg *sendmsg = new size100000Msg;

	  sendmsg->trial_num=-1;
	  thisgroup[0]=>SendSize100000Msg(sendmsg);
	}
      else if (i_num==100000)
	{
	  size1000000Msg *sendmsg = new size1000000Msg;

	  sendmsg->trial_num=-1;
	  thisgroup[0]=>SendSize1000000Msg(sendmsg);
	}
      else if (i_num == 1000000)
	{
	  CharmExit() ; // behaves differently from exit()
			// see manual for details
	}
      else {
	CPrintf("Strange termination\n");
	CharmExit();
      }
    }  
  }


} ;


chare class main {

    public:
        main()
        {        
                InitMsg *msg = new InitMsg ;
                
		newgroup PingPong(msg) ;
        }
} ;


