/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: tvid.p,v $
 *	$Author: rbrunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.3 $	$Date: 1998/03/16 21:29:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: tvid.p,v $
 * Revision 2.3  1998/03/16 21:29:35  rbrunner
 * Fixed include file problems
 *
 * Revision 2.2  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.1  1995/10/27  21:55:28  jyelon
 * Changed CmiNumPe to CkNumPes or CNumPes or CmiNumPes
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/04/24  22:42:39  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "tvid.interface"
module tvid {

#include "charm-inc.h"

message {
    	int  level;
        ChareIDType cid;
} MSG1;

void initfn()
{
}

chare start {

int n;
int iteration;
EntryPointType retEP;
ChareIDType retID;

entry begin:(message main_test::INIT_MSG *imsg)
{
    MSG1 *pMsg;

    iteration = imsg->iteration;
    retEP = imsg->retEP;
    retID = imsg->retID;
    n = 100; 


    pMsg  = (MSG1 *) CkAllocMsg(MSG1);
    pMsg->cid = ThisChareID;
    pMsg->level = n;
    CreateChare(fib1, fib1@goal, pMsg, NULL_VID, 1);
    StartQuiescence(Quiescence, &ThisChareID);
    CkFreeMsg(imsg);
}


entry Quiescence: (message QUIESCENCE_MSG *dmsg) 
{
	main_test::IT_MSG *imsg;
	CkPrintf("TVID:Quiescence Detected.\n");
    	CkPrintf("TVID:--------------------------------------------------\n");
	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = iteration;

	SendMsg(retEP, imsg, &retID);
	CkFreeMsg(dmsg);
}

entry final : (message MSG1 *msg)
{
	MSG1 *tmsg;

CkPrintf("TVID:In main@final on  %d the message is %d \n",CkMyPe(), msg->level);
	tmsg = (MSG1 *) CkAllocMsg(MSG1);
	tmsg->level = 400;
	SendMsg(fib2@pass3, tmsg, &(msg->cid));	
	CkFreeMsg(msg);
}

entry finallyfinal : (message MSG1 *msg)
{
CkPrintf("TVID:In main@finalllyfinal on  %d the message is %d \n",CkMyPe(), msg->level);
	CkFreeMsg(msg);
}

} 

chare fib1 {

entry goal: (message MSG1 *msg) 
{
	MSG1 *pmsg;
	MSG1 *tmsg;

     	pmsg = (MSG1 *) CkAllocMsg(MSG1);
     	tmsg = (MSG1 *) CkAllocMsg(MSG1);

CkPrintf("TVID:In fib1@goal on  %d the message is %d \n",CkMyPe(), msg->level);
     	pmsg->level = msg->level;
	tmsg->level = msg->level;
     	pmsg->cid = msg->cid;
     	CreateChare(fib2, fib2@pass1, pmsg, &(tmsg->cid), 2);
     	CreateChare(fib3, fib3@pass1, tmsg, NULL_VID, 3);
	CkFreeMsg(msg);
}
}

chare fib2 {

ChareIDType chareid;

entry pass1 : (message MSG1 *msg)
{
CkPrintf("TVID:In fib2@pass1 on %d the message is %d  \n",CkMyPe(), msg->level);
	chareid = msg->cid;
	CkFreeMsg(msg);
}

entry pass2 : (message MSG1 *msg)
{
	MSG1 *tmsg;

CkPrintf("TVID:In fib2@pass2 on %d the message is %d \n",CkMyPe(), msg->level);
	tmsg = (MSG1 *) CkAllocMsg(MSG1);
	tmsg->level = 300;
	tmsg->cid = msg->cid;
	SendMsg(start@final, tmsg, &chareid);
	CkFreeMsg(msg);
}

entry pass3 : (message MSG1 *msg)
{
	MSG1 *tmsg;

CkPrintf("TVID:In fib2@pass3 on %d the message is %d \n",CkMyPe(), msg->level);
	tmsg = (MSG1 *) CkAllocMsg(MSG1);
	tmsg->level = 500;
	SendMsg(start@finallyfinal, tmsg, &chareid);
	CkFreeMsg(msg);
}
}

chare fib3 {

entry pass1 : (message MSG1 *msg)
{
	MSG1 *tmsg;

CkPrintf("TVID:In fib3@pass1 on %d the message is %d  \n",CkMyPe(), msg->level);
	tmsg = (MSG1 *) CkAllocMsg(MSG1);
	tmsg->level = 200;
	tmsg->cid = msg->cid;
	SendMsg(fib2@pass2,tmsg,&(msg->cid));
	CkFreeMsg(msg);
}
}
}
