/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ttab.p,v $
 *	$Author: rbrunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.3 $	$Date: 1998/03/16 21:29:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ttab.p,v $
 * Revision 2.3  1998/03/16 21:29:35  rbrunner
 * Fixed include file problems
 *
 * Revision 2.2  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.1  1995/10/27  21:55:28  jyelon
 * Changed CmiNumPe to CkNumPes or CNumPes or CmiNumPes
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/04/24  22:42:39  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "ttab.interface"
module ttab {

#include "charm-inc.h"

#define N 15
#define M 10
#define F 5
#define L 7
#define NULL 0

message {
	int x;
} DUMMY;

message {
    	int	 n;
    	char s[N];
} MSG1;

table datatable;

void initfn()
{
}


/* ****************************************** */
chare start {

int iteration;
EntryPointType retEP;
ChareIDType retID;

entry begin:(message main_test::INIT_MSG *imsg)
{    
     	DUMMY *msg1, *msg2, *msg3, *msg4;

     	iteration = imsg->iteration;
     	retEP = imsg->retEP;
     	retID = imsg->retID;

	msg1 = (DUMMY *) CkAllocMsg(DUMMY);
	msg2 = (DUMMY *) CkAllocMsg(DUMMY);
	msg3 = (DUMMY *) CkAllocMsg(DUMMY);
	msg4 = (DUMMY *) CkAllocMsg(DUMMY);
     	CreateChare(tables, tables@GOAL, msg1, NULL_VID, 0);
     	CreateChare(tables, tables@GOAL, msg2, NULL_VID, 1);
     	CreateChare(tables, tables@GOAL, msg3, NULL_VID, 2);
     	CreateChare(tables, tables@GOAL, msg4, NULL_VID, 3);
	StartQuiescence(Quiescence, &ThisChareID);
	CkFreeMsg(imsg);
}

entry Quiescence: (message QUIESCENCE_MSG *dmsg) 
{
	main_test::IT_MSG *imsg;

     	CkPrintf("TTAB:Quiescence Detected. \n");
	CkPrintf("TTAB:---------------------------------------------------------\n");
	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = iteration;

	SendMsg(retEP, imsg, &retID);
	CkFreeMsg(dmsg);
}

}

chare tables {
	
	int i;
	int x;
	int key[M];
	char *data[M];
	int left;


entry GOAL: (message DUMMY *msg) {

	int magic = CkMyPe();

CkPrintf("TTAB:Chare created on processor %d\n", CkMyPe()); 

	for (i=0; i< M; i++)
	{
		x = rand() % 1000 + (magic * 1000);
		key[i] = x;
		data[i] = (char *) CkAlloc(10);
		sprintf(data[i],"A%d",i);
CkPrintf("TTAB: ELEMENT %d has data %s and key %d\n", i, data[i], key[i]);
	}
	
	left = M;
	for (i=0; i<M; i++)
		TblInsert(datatable, key[i], data[i], sizeof(data[i]),
			tables@RESPONSE1, &ThisChareID);
	CkFreeMsg(msg);
}

entry RESPONSE1 : (message TBL_MSG *msg) {
	CkPrintf("TTAB:RESPONSE1: Inserted data %s with key %d\n",
			 msg->data, msg->key);
	TblFind(datatable, msg->key, tables@RESPONSE2, &ThisChareID, 	
		TBL_NEVER_WAIT);
	CkFreeMsg(msg);
}
		
entry RESPONSE2 : (message TBL_MSG *msg) {
	left--;
	if (msg->data != NULL)
		CkPrintf("TTAB:RESPONSE2 : Found data %s with key %d\n",msg->data, msg->key);
	else
		CkPrintf("TTAB:RESPONSE2 : Unable to find data with key %d\n", msg->key);
	if (left<=0)
	{
		for (i=F; i<L; i++)
			CkPrintf("TTAB:deleting with key %d\n",key[i]);
		for (i=F; i<L; i++)
			TblDelete(datatable, key[i], tables@RESPONSE3, &ThisChareID, 
				 TBL_REPLY);
	}
	CkFreeMsg(msg);
}

entry RESPONSE3 : (message TBL_MSG *msg) {
	if (msg->data != NULL)
		CkPrintf("TTAB:RESPONSE3: Deleted data %s with key %d\n", msg->data, msg->key);
	else
		CkPrintf("TTAB:RESPONSE3 : Unable to delete with key %d\n", msg->key); 
	TblFind(datatable, msg->key, tables@RESPONSE4, &ThisChareID,
		 TBL_NEVER_WAIT);
	CkFreeMsg(msg);
}

entry RESPONSE4 : (message TBL_MSG *msg) {
	if (msg->data != NULL)
		CkPrintf("TTAB:RESPONSE4 : Found data %s with key %d\n",msg->data, msg->key);
	else
		CkPrintf("TTAB:RESPONSE4 : Unable to find data with key %d\n", msg->key);
	CkFreeMsg(msg);
}
}
}
