/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ftab.p,v $
 *	$Author: rbrunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.2 $	$Date: 1998/03/16 21:29:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ftab.p,v $
 * Revision 2.2  1998/03/16 21:29:32  rbrunner
 * Fixed include file problems
 *
 * Revision 2.1  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/06/20  20:09:09  jyelon
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "ftab.interface"

module ftab {


/************************************************************************/
/*Counting the number of fib of n identical objects into K piles */
/* Using dynamic tables to avoid duplication			        */
/************************************************************************/

#include "charm-inc.h"

readonly int grainSize, topFib;
table fibtbl;

message { 
	int n;
	ChareIDType parentID;
	EntryPointType sendToEp;
} 
ProblemMsg;

message {
	int fib;
} 
SolutionMsg;

void initfn()
{
	topFib = 10;
	grainSize = 5;
	ReadInit(topFib);
	ReadInit(grainSize); 
}

chare start {
	int k;
main_test::INIT_MSG *store;

entry begin : (message main_test::INIT_MSG *imsg)
{  
	ProblemMsg * pMsg ;

	store = imsg;

	pMsg = (ProblemMsg *) CkAllocMsg( ProblemMsg);
	pMsg->n = topFib;
	pMsg->sendToEp = start@Solution;
	pMsg->parentID = ThisChareID;
	CreateChare(fib, fib@InitSubGoal, pMsg);  
}

entry Solution:  (message SolutionMsg * msg)
{ 
	main_test::IT_MSG *imsg;

	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = store->iteration;


	CkPrintf("FTAB:The answer is: %d at %f seconds.\n", msg->fib, CmiTimer());
	SendMsg(store->retEP, imsg, &(store->retID));
	CkFreeMsg(msg);
	CkFreeMsg(store);
}
}

chare fib 
{
	ChareIDType parent;
	EntryPointType parentEP;
	int total, count;
	int n,k;
	int store;
	int key;

entry InitSubGoal: (message ProblemMsg *msg)
{ 
	parent = msg->parentID;     /* struct copy. */
	parentEP = msg->sendToEp;
	n = msg->n; 
	store = 1;
	key = n ;
	TblFind(fibtbl, key, TblChecked, &ThisChareID, TBL_WAIT_AFTER_FIRST); 
	CkFreeMsg(msg);
}

entry TblChecked: (message TBL_MSG *msg)
{ 
	ProblemMsg *msg1, *msg2;
	int temp;

	if (msg->data != NULL)
	{
		temp = *((int *) msg->data);
		store = 0;
		PrivateCall(sendResponse(temp));
	}
	else 
	{
		if (n  < ReadValue(grainSize)) 
			PrivateCall(sendResponse( Fib(n)) );
		else       /* Otherwise, start parallel subcomputations. */
		{
			total = 0; 
			count = 2;
			msg1 =  (ProblemMsg *) CkAllocMsg( ProblemMsg );
			msg2 =  (ProblemMsg *) CkAllocMsg( ProblemMsg );
			msg1->n = n-1;      
			msg1->sendToEp = fib@Response;
			msg1->parentID = ThisChareID;
			CreateChare(fib, InitSubGoal, msg1);   /* fib(n-1,k-1) */
			msg2->n = n-2; 
			msg2->parentID = ThisChareID;
			msg2->sendToEp = fib@Response;
			CreateChare(fib, InitSubGoal, msg2);    /* fib(n-k,k) */
		}
	}
	CkFreeMsg(msg);
}

entry Response: (message SolutionMsg * msg)
{ 
	total += msg->fib;
	CkFreeMsg(msg);
	if (--count == 0)
		PrivateCall(sendResponse(total));
}

private sendResponse(value)
int value;
{ 
	SolutionMsg * resp;
	resp = (SolutionMsg *) CkAllocMsg( SolutionMsg);
	resp->fib = value;
	SendMsg(parentEP, resp, &parent);
	if (store) TblInsert(fibtbl, key, &value, sizeof(value), -1, 
				NULL);
}
}

Fib(n)
int n;
{ 
	if (n<2)
		return(n);
	else
		return(Fib(n-1)+Fib(n-2));
}
}
