/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: fboc.p,v $
 *	$Author: rbrunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.5 $	$Date: 1998/03/16 21:29:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: fboc.p,v $
 * Revision 2.5  1998/03/16 21:29:31  rbrunner
 * Fixed include file problems
 *
 * Revision 2.4  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.3  1995/10/27  21:55:28  jyelon
 * Changed CmiNumPe to CkNumPes or CNumPes or CmiNumPes
 *
 * Revision 2.2  1995/09/19  23:28:04  jyelon
 * Fixed bug.
 *
 * Revision 2.1  1995/07/26  20:54:11  knauff
 * Changed 'MainChareID' in dynamic::GOAL to 'MyChareID'
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.4  1995/06/20  20:09:09  jyelon
 * *** empty log message ***
 *
 * Revision 1.3  1995/06/20  00:27:29  narain
 * *** empty log message ***
 *
 * Revision 1.2  1995/04/24  22:42:39  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "fboc.interface"

module fboc {
#include "charm-inc.h"

#define N 20 
#define NULL 0
#define TRUE 1
#define FALSE 0

message {
    int level;
    int BocNum;
    int  fibNum;
    ChareIDType  ParentID;
} MSG1;

message{
    	int  n;
} MSG2;

message {
    	int  count[N];
}  MSG3;

message {
    	ChareNumType rspData;
} MSGUP;

message {
    	int  dummy;
        ChareIDType startchareID;
} NMSG;

message {
	varSize int dummy[];
	varSize int bull[];
	int x;
} RMSG;

message {
	ChareNumType bocnum;
} TMP_MSG;

readonly int topFib, GrainSize;
readonly RMSG * read_msg;

void initfn()
{
     int i;
     int sizes[2];

     /*
     CkPrintf("FBOC:Enter Fibnocci number: ");
     CkScanf("%d",&topFib);
     CkPrintf("FBOC:Enter Grain size: ");
     CkScanf("%d",&GrainSize);
     */
     topFib = 10;
     GrainSize = 5;

     ReadInit(topFib);
     ReadInit(GrainSize);

     sizes[0] = 10; sizes[1] = 25;
     read_msg = (RMSG *) CkAllocMsg(RMSG, sizes);
     read_msg->x = 10;
     for (i=0; i<sizes[0]; i++)
     	read_msg->dummy[i] = 3.14*i;
     for (i=0; i<sizes[1]; i++)
	read_msg->bull[i] = i;
     ReadMsgInit(read_msg);

}

chare start {

int found;
ChareNumType  BocNum;
ChareIDType mainid;

main_test::INIT_MSG *store;

entry begin: (message main_test::INIT_MSG *imsg)
{
     MSG2 *msg;

     store = imsg;
     found = 0;
     msg = (MSG2 *) CkAllocMsg(MSG2);
     msg->n = (topFib - GrainSize  + 1);
     CreateBoc(Counter,Counter@BranchInit, msg, start@bocCreated,&ThisChareID);
}

entry bocCreated: (message TMP_MSG *msg)
{
     MSG1 *pMsg;

     BocNum = msg->bocnum;
     CkFreeMsg(msg);
     pMsg  = (MSG1 *) CkAllocMsg(MSG1);
     pMsg->fibNum = topFib;  
     pMsg->BocNum=BocNum;
     pMsg->level = 0;
     pMsg->ParentID = ThisChareID;
     CreateChare(fib, fib@GOAL, pMsg);
     mainid = ThisChareID;
     StartQuiescence(Quiescence1, &mainid); 
}

entry Quiescence1:  (message QUIESCENCE_MSG  *dmsg)
{
	NMSG *msg;
	msg = (NMSG *) CkAllocMsg(NMSG);
        msg->startchareID = ThisChareID;
	CreateChare(dynamic, dynamic@GOAL, msg, NULL_VID, 2); 
        StartQuiescence(Quiescence2, &mainid); 
	CkFreeMsg(dmsg);
}

entry Quiescence2:  (message QUIESCENCE_MSG  *dmsg)
{
	main_test::IT_MSG *imsg;

	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = store->iteration;

	SendMsg(store->retEP, imsg, &(store->retID));
	CkFreeMsg(dmsg);
	CkFreeMsg(store);
}


entry ReturnBocNum: (message MSGUP *msg)
{
     MSG1 *pMsg;

     BocNum = msg->rspData;
     pMsg  = (MSG1 *) CkAllocMsg(MSG1);
     pMsg->fibNum = topFib;  
     pMsg->BocNum=BocNum;
     pMsg->level = 0;
     pMsg->ParentID = ThisChareID;
     CreateChare(fib, fib@GOAL, pMsg);
     CkFreeMsg(msg);
}


entry MAINEP1:   (message MSGUP *m)
{
    CkPrintf("FBOC:Main ep message received.\n");
    CkPrintf("FBOC:Result = %d\n", m->rspData);
    CkFreeMsg(m);
    BranchCall(BocNum, Counter@Collect());
}
}

chare fib
{
int	isFinal;
int	fibNum;
int	rspNum;
int	rspData;
ChareIDType	ParentID;

entry GOAL: (message MSG1 *msg1P) {
    int 	n,i, fibVal;
    MSG1	*ptr1;
    MSGUP	*ptr2;
    int 	level;
    int         bocNum;

    bocNum = msg1P->BocNum;
    n = msg1P->fibNum;
    fibNum = n;
    level = msg1P->level;
    BranchCall(bocNum, Counter@increment(level));
    ParentID = msg1P->ParentID;
    isFinal = ( n == ReadValue(topFib) ) ? TRUE : FALSE;
    if (n <= ReadValue(GrainSize))
    {
       ptr2 = (MSGUP *) CkAllocMsg(MSGUP);
       fibVal = Fib(n);
       CkFreeMsg(msg1P);
       ProcessResult(isFinal, &ParentID, fibVal, ptr2);
    }
    else 
    {
       rspNum= 2;
       rspData= 0;
       ptr1 = (MSG1 *) CkAllocMsg(MSG1);
       ptr1->fibNum = n-1;
       ptr1->BocNum = msg1P->BocNum;
       ptr1->level = msg1P->level + 1;
       msg1P->level += 1;
       ptr1->ParentID = ThisChareID;
       msg1P->fibNum = n-2;
       msg1P->ParentID = ThisChareID;
       CreateChare(fib, fib@GOAL, ptr1);
       CreateChare(fib, fib@GOAL, msg1P);
     }
}

entry RESPONSE: (message MSGUP *msg2P) 
{
    rspNum--;
    rspData += msg2P->rspData;
    if (rspNum == 0) 
       ProcessResult(isFinal, &ParentID,  rspData, msg2P);
    else
       CkFreeMsg(msg2P);
}
}



BranchOffice Counter {

	int i;
	int count[N];
	int aggregate[N];
	int BocNum;
	int total;
	int n;


	entry BranchInit : (message MSG2 *msg)
	{
		int j;
		ChareIDType chareid;

        	n = msg->n;
		for (i=0;i<n;i++)
		{
			aggregate[i] = 0;
			count[i] = 0;
		}
		total = CkNumPes();
		CkFreeMsg(msg);
	}
	
	entry CollectFromBranches : (message MSG3 *msg)
	{
    		total--;
    		for (i=0;i<n;i++)
    			aggregate[i]+=msg->count[i];
    		if (total==0)
      			for (i=0;i<n;i++)
         		CkPrintf("FBOC:Number of nodes at level %3d = %3d\n",
					i, aggregate[i]);
		CkFreeMsg(msg);
	}

	entry NodeCollect : (message NMSG *msg)
	{
		int mainpe;
		MSG3 *tmsg;
		
		mainpe = 0;
    		tmsg =(MSG3 *)  CkAllocMsg(MSG3);
    		for (i=0;i<n;i++)
     			tmsg->count[i]=count[i];
    		SendMsgBranch(CollectFromBranches,tmsg, mainpe);
		CkFreeMsg(msg);
	}

	public increment(j)
	int j;
	{
    		(count[j])++;
	}

	public Collect()
	{
		NMSG *msg;
		
    		msg=(NMSG *) CkAllocMsg(NMSG);
    		BroadcastMsgBranch(NodeCollect,msg);
	}
}



ProcessResult(top, CID, value, msg)
int top;
ChareIDType *CID;
int value;
MSGUP *msg;
{
    if (top) {
       CkPrintf("FBOC:Fib %d = %d at Time %f sec.\n", ReadValue(topFib) , value, CmiTimer());
     /*CkExit(); Commented out to test Quiescence */
       msg->rspData = value;
       SendMsg(start@MAINEP1, msg, CID /* should be mainchareId */);
   }
   else {
     msg->rspData = value;
     SendMsg(fib@RESPONSE, msg, CID);
   }
   ChareExit();
}

Fib(x)
int x;
{
    if (x < 2) return(x);
    return(Fib(x-1)+Fib(x-2));
}

chare dynamic {
entry GOAL : (message NMSG *nmsg)
{
	MSG2 *msg;
	RMSG *tmsg;

	tmsg = ReadValue(read_msg);
	CkPrintf("FBOC:\nCharacteristics of Read Message :\n");
	CkPrintf("FBOC:\tx = %d\n", tmsg->x);
	CkPrintf("FBOC:\tdummy[5] = %d\n", tmsg->dummy[5]);
	CkPrintf("FBOC:\tbull[13] = %d\n", tmsg->bull[13]);
	CkPrintf("FBOC:\n\n");

	msg = (MSG2 *) CkAllocMsg(MSG2);
	msg->n = ReadValue(topFib) - ReadValue(GrainSize) + 1;
      	CreateBoc(Counter, Counter@BranchInit, msg, start@ReturnBocNum,
				&(nmsg->startchareID));
	CkFreeMsg(nmsg);
}
}
}
