/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: fam.p,v $
 *	$Author: rbrunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.2 $	$Date: 1998/03/16 21:29:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: fam.p,v $
 * Revision 2.2  1998/03/16 21:29:31  rbrunner
 * Fixed include file problems
 *
 * Revision 2.1  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.3  1995/06/20  20:09:09  jyelon
 * *** empty log message ***
 *
 * Revision 1.2  1995/06/20  00:27:29  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "fam.interface"

module fam {
#include "charm-inc.h"


/************************************************************************/
/*									*/
/*	N'th Fiboncci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/

#define N 20
#define TRUE 1
#define FALSE 0

message {
    	int	fibNum;
    	int 	level;
	ChareIDType parentID;
} MSG1;

message {
    	int 	rspData;
} MSGUP;

message {
    	int 	counter[N];
} MSG_LEVEL;


readonly int topFib, grainSize;
readonly int acc1id, acc2id, mono1id;


accumulator {

	MSGUP *msg;

	MSGUP * initfn (data)
	MSGUP *data;
	{
		msg = (MSGUP *) CkAllocMsg(MSG_LEVEL);
		msg->rspData = 0;
		return(msg);
	}

	addfn ()
	{
		(msg->rspData)++;
	}

	combinefn (y)
	MSGUP *y;
	{
		msg->rspData += y->rspData;
	}
}  ACC1;

accumulator {

	MSG_LEVEL *msg;

	MSG_LEVEL * initfn (data)
	MSGUP *data;
	{
		int i;

		msg = (MSG_LEVEL *) CkAllocMsg(MSG_LEVEL);
		for (i=0; i<N; i++)
			msg->counter[i] = 0;
		return(msg);
	}
	
	addfn (y)
	int y;
	{
		msg->counter[y]++;
	}

	combinefn (y)
	MSG_LEVEL *y;
	{
		int 	i;
		for (i=0;i<20;i++)
			msg->counter[i] += y->counter[i];
	}

} ACC2;

monotonic  {
	
	MSGUP *msg;

	MSGUP * initfn (data)
	MSGUP *data;
	{
		msg = (MSGUP *) CkAllocMsg(MSGUP);
		msg->rspData = 0;
		return(msg);
	}
	
	updatefn (y)
	MSGUP *y;
	{
		if (msg->rspData < y->rspData)
		{
			msg->rspData = y->rspData;
			return(1);
		}
		return(0);	
	}
} MONO1;

void initfn()
{
	MSGUP	*msg1, *msg2, *msg3;


	topFib = 10;
	grainSize = 5;

     	ReadInit(topFib);
     	ReadInit(grainSize);
    	 
	msg1 = (MSGUP *) CkAllocMsg(MSGUP);
	msg2 = (MSGUP *) CkAllocMsg(MSGUP);
	msg3 = (MSGUP *) CkAllocMsg(MSGUP);
	msg1->rspData = 10;
	acc1id = CreateAcc(ACC1, msg1);
     	ReadInit(acc1id); 
	msg2->rspData = 20;
     	acc2id = CreateAcc(ACC2, msg2);
     	ReadInit(acc2id);  
	msg3->rspData = 30;
     	mono1id =  CreateMono(MONO1, msg3);
     	ReadInit(mono1id);
}

/* ****************************************** */
chare start {

main_test::INIT_MSG *store;

entry begin: (message main_test::INIT_MSG *imsg)
{    
     	int   	i;
	int 	data;
     	MSG1 	*pMsg;

	store = imsg;

     	pMsg  = (MSG1 *) CkAllocMsg(MSG1);
     	pMsg->fibNum = topFib;  
     	pMsg->level = 0;
	pMsg->parentID = ThisChareID;
     	CreateChare(fib, fib@GOAL, pMsg);
	StartQuiescence(Quiescence, &ThisChareID);
}

entry Quiescence: (message QUIESCENCE_MSG *msg) 
{
	main_test::IT_MSG *imsg;

	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = store->iteration;

     	CkPrintf("FAM:Quiesence: Time = %f\n",CmiTimer());
     	CkPrintf("FAM:Quiescence Detected.\n");
     	CkPrintf("FAM:Value of bound is %d\n", 
		((MSGUP *) MonoValue(mono1id))->rspData);
	SendMsg(store->retEP, imsg, &(store->retID));
	CkFreeMsg(msg);
	CkFreeMsg(store);
	
}

entry MAINEP1:   (message MSGUP *m)
{
     	CkPrintf("FAM:Main ep message received.\n");
     	CkPrintf("FAM:Result = %d\n", m->rspData);
     	CkPrintf("FAM:*************************************************\n");
     	CkPrintf("FAM:\t\tTime Elapsed in milliseconds is %f\n",CmiTimer());
     	CkPrintf("FAM:*************************************************\n");
	CkFreeMsg(m);
}

entry MAINEP2: (message MSG_LEVEL *msg){
     	int 	i;

     	for (i=0; i<N;i++)
     		if (msg->counter[i] >0)
			CkPrintf("FAM:Number of nodes at level %d = %d\n", i,
					msg->counter[i]);
	CkPrintf("FAM:MAINEP2: Time = %f\n", CmiTimer());
	CkFreeMsg(msg);
}

entry MAINEP3: (message MSGUP *msg){
     	CkPrintf("FAM:Total number of nodes = %d\n", msg->rspData);
     	CkPrintf("FAM:Value of bound is %d\n", 
		((MSGUP *) MonoValue(mono1id))->rspData);
	CkPrintf("FAM:MAINEP3: Time = %f\n", CmiTimer());
	CkFreeMsg(msg);
} 
} 

chare fib {
     	int	isFinal;
      	int	fibNum;
      	int	rspNum;
      	int	rspData;
	ChareIDType parentID;

entry GOAL: (message MSG1 *msg1P) {
     	int 	n,i, fibVal;
     	MSG1	*ptr1;
     	MSGUP	*ptr2;
	MSGUP   *monomsg;
     	int 	temp;


    	n = msg1P->fibNum;
    	fibNum = n;

    	Accumulate( ReadValue(acc1id), addfn());
    	Accumulate( ReadValue(acc2id), addfn(msg1P->level));
	
   	temp = ReadValue(topFib) - n;;
	monomsg = (MSGUP *) CkAllocMsg(MSGUP);
	monomsg->rspData = temp;
    	NewValue( ReadValue(mono1id), updatefn(monomsg));
	CkFreeMsg(monomsg);
	
    	isFinal = ( msg1P->fibNum == ReadValue(topFib) ) ? TRUE : FALSE;
	parentID = msg1P->parentID;
    	if (msg1P->fibNum <= ReadValue(grainSize))
    	{ 
        	ptr2 = (MSGUP *) CkAllocMsg(MSGUP);
        	fibVal = Fib(n);
        	CkFreeMsg(msg1P);
        	ProcessResult(isFinal, &parentID, fibVal, ptr2);
    	}
    	else 
    	{
        	rspNum= 2;
        	rspData= 0;
        	ptr1 = (MSG1 *) CkAllocMsg(MSG1);
        	ptr1->fibNum = n-1;
        	ptr1->level = msg1P->level + 1;
    		ptr1->parentID = ThisChareID;
        	msg1P->fibNum = n-2;
        	msg1P->level++;
    		msg1P->parentID = ThisChareID;
        	CreateChare(fib, fib@GOAL, ptr1);
        	CreateChare(fib, fib@GOAL, msg1P);
   	}
}

entry RESPONSE: (message MSGUP *msg2P) {
       	rspNum--;
 	rspData += msg2P->rspData;
      	if (rspNum == 0) 
          	ProcessResult(isFinal, &parentID,  rspData, msg2P);
      	else
		CkFreeMsg(msg2P);
}
}


ProcessResult(top, CID, value, msg)
int 	top;
ChareIDType *CID;
int 	value;
MSGUP 	*msg;
{
	if (top)  
	{
  		msg->rspData = value;
  		SendMsg(start@MAINEP1, msg, CID);
  		CollectValue(ReadValue(acc1id), start@MAINEP3, CID);
  		CollectValue(ReadValue(acc2id), start@MAINEP2, CID);
	}
	else
	{
  		msg->rspData = value;
  		SendMsg(fib@RESPONSE, msg, CID);
	}
}

Fib(x)
int x;
{
	if (x < 2) return(x);
 	return(Fib(x-1)+Fib(x-2));
}


}


