/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: acc.p,v $
 *	$Author: rbrunner $	$Locker:  $		$State: Exp $
 *	$Revision: 2.2 $	$Date: 1998/03/16 21:29:30 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: acc.p,v $
 * Revision 2.2  1998/03/16 21:29:30  rbrunner
 * Fixed include file problems
 *
 * Revision 2.1  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/06/20  20:09:09  jyelon
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "iacc_count.int"
#include "facc_count.int"
#include "iacc_hist.int"

#include "testpgm.interface"
#include "acc.interface"

module acc {

#include "charm-inc.h"

/************************************************************************/
/*									*/
/*	N'th Fiboncci number, using the naive recursive algorithm,	*/
/*	and explicit grainsize control.				        */
/************************************************************************/

#define N 20
#define TRUE 1
#define FALSE 0


message {
    	int	fibNum;
    	int 	level;
	ChareIDType parentID;
} MSG1;

message {
    	int 	rspData;
} MSGUP;

message {
    	varSize int 	counter[];
} MSG_LEVEL;


readonly int topFib, grainSize;
readonly int acc1id, acc2id, acc3id; 

void initfn()
{
	topFib = 10;
	grainSize = 5;

	ReadInit(topFib);
	ReadInit(grainSize);


	acc1id = ICount::Create();
     	ReadInit(acc1id); 
	acc2id = IHistogram::Create(topFib - grainSize + 1);
     	ReadInit(acc2id);  
	acc3id = FCount::Create();
     	ReadInit(acc3id); 
}

/* ****************************************** */
chare start {
main_test::INIT_MSG *store;
entry begin : (message main_test::INIT_MSG *imsg)
{    
     	int   	i;
	int 	data;
     	MSG1 	*pMsg;

	store = imsg;
     	pMsg  = (MSG1 *) CkAllocMsg(MSG1);
     	pMsg->fibNum = topFib;  
     	pMsg->level = 0;
        pMsg->parentID = ThisChareID;
     	CreateChare(fib, fib@GOAL, pMsg);
	StartQuiescence(start@Quiescence, &ThisChareID);
}


entry Quiescence: (message QUIESCENCE_MSG *dmsg) 
{
	main_test::IT_MSG *imsg;
	
	imsg = (main_test::IT_MSG *) CkAllocMsg(main_test::IT_MSG);
	imsg->iteration = store->iteration;

     	CkPrintf("ACC:Quiesence: Time = %f\n",CmiTimer());
     	CkPrintf("ACC:Quiescence Detected in ACC.\n");
	SendMsg(store->retEP, imsg, &(store->retID));
	CkFreeMsg(store);
	CkFreeMsg(dmsg);
}

entry MAINEP1:   (message MSGUP *m)
{
     	CkPrintf("ACC:Main ep message received.\n");
     	CkPrintf("ACC:Result = %d\n", m->rspData);
     	CkPrintf("ACC:************************************************\n");
     	CkPrintf("ACC:\t\tTime Elapsed in seconds is %f\n",CmiTimer());
     	CkPrintf("ACC:************************************************\n");
	CkFreeMsg(m);
}

entry MAINEP2: (message ICount::MSG *msg){
	CkPrintf("ACC:MAINEP2: Total number of nodes = %d\n", msg->data);
	CkFreeMsg(msg);
}

entry MAINEP3: (message IHistogram::MSG *msg){
     	int 	i;

     	for (i=0; i<msg->size;i++)
     		if (msg->data[i] >0)
			CkPrintf("ACC:Number of nodes at level %d = %d\n", i,
					msg->data[i]);
	CkPrintf("ACC:MAINEP3: Time = %f\n", CmiTimer());
	CkFreeMsg(msg);
}

entry MAINEP4: (message FCount::MSG *msg){
	CkPrintf("ACC:MAINEP4: Total number of nodes = %f\n", msg->data);
	CkFreeMsg(msg);
}

} 

chare fib {
     	int	isFinal;
      	int	fibNum;
      	int	rspNum;
      	int	rspData;
	ChareIDType parentID;

entry GOAL: (message MSG1 *msg1P) {
     	int 	n,i, fibVal;
     	MSG1	*ptr1;
     	MSGUP	*ptr2;
     	int 	temp;


    	n = msg1P->fibNum;
    	fibNum = n;

	ICount::Add(acc1id, 1);
	FCount::Add(acc3id, 1.0);
	IHistogram::Add(acc2id, msg1P->level, 1);
	
    	isFinal = ( msg1P->fibNum == ReadValue(topFib) ) ? TRUE : FALSE;
	parentID = msg1P->parentID;
    	if (msg1P->fibNum <= ReadValue(grainSize))
    	{ 
        	ptr2 = (MSGUP *) CkAllocMsg(MSGUP);
        	fibVal = Fib(n);
        	CkFreeMsg(msg1P);
        	ProcessResult(isFinal, &parentID, fibVal, ptr2);
    	}
    	else 
    	{
        	rspNum= 2;
        	rspData= 0;
        	ptr1 = (MSG1 *) CkAllocMsg(MSG1);
        	ptr1->fibNum = n-1;
        	ptr1->level = msg1P->level + 1;
    		ptr1->parentID = ThisChareID;
        	msg1P->fibNum = n-2;
        	msg1P->level++;
    		msg1P->parentID = ThisChareID;
        	CreateChare(fib, fib@GOAL, ptr1);
        	CreateChare(fib, fib@GOAL, msg1P);
   	}
}

entry RESPONSE: (message MSGUP *msg2P) {
       	rspNum--;
 	rspData += msg2P->rspData;
      	if (rspNum == 0) 
          	ProcessResult(isFinal, &parentID,  rspData, msg2P);
      	else
		CkFreeMsg(msg2P);
}
}


ProcessResult(top, CID, value, msg)
int 	top;
ChareIDType *CID;
int 	value;
MSGUP 	*msg;
{
	if (top)  
	{
  		msg->rspData = value;
  		SendMsg(start@MAINEP1, msg, CID);
  		ICount::Collect(ReadValue(acc1id), start@MAINEP2, CID);
  		IHistogram::Collect(ReadValue(acc2id), start@MAINEP3, CID);
  		FCount::Collect(ReadValue(acc3id), start@MAINEP4, CID);
	}
	else
	{
  		msg->rspData = value;
  		SendMsg(fib@RESPONSE, msg, CID);
	}
}

Fib(x)
int x;
{
	if (x < 2) return(x);
 	return(Fib(x-1)+Fib(x-2));
}


}
