// Hey emacs, this is -*- C++ -*-

#ifndef _ftab_h_
#define _ftab_h_

/************************************************************************/
/*Counting the number of fib of n identical objects into K piles */
/* Using dynamic tables to avoid duplication			        */
/************************************************************************/

#include "messages.h"
#include "megatest++.h"
#include "generic_class.h"
#include "fib.h"

/************************************************************/

/* In ftab.P
readonly int ftab_grainSize, ftab_topFib;
table fibtbl;
*/

extern void ftab_initfn();

/************************************************************/

message class ProblemMsg { 
public:     int n;
     ChareIDType parentID;
     EntryPointType sendToEp;
};

message class SolutionMsg {
public:     int fib;
};

/************************************************************/

chare class ftab_start : public generic_class {

  public:
     int k;
     INIT_MSG *store;

  entry:

     ftab_start (INIT_MSG *imsg);

     void Solution (SolutionMsg * msg);

};

/************************************************************/

chare class ftab_fib : public generic_class {

  public:
     ftab_fib handle parent;
     EntryPointType parentEP;
     int total, count;
     int n,k;
     int store;
     int key;
     
  entry:
     ftab_fib (ProblemMsg *msg);
     
     void TblChecked (TableMessage *msg);

     void Response (SolutionMsg * msg);
     
  private:
     void sendResponse(int value);
};

/************************************************************/

#endif
