/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: vars.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/11/26 19:17:21 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: vars.c,v $
 * Revision 1.4  1997/11/26 19:17:21  milind
 * Fixed some portability bugs due to varying integer and pointer sizes.
 *
 * Revision 1.3  1996/11/23 03:12:46  milind
 * Chnged the size parameter in CpmMakeThreadSize to 0 in vars.c and
 * fibthr.c in megacon test. This allocates the max sized stack possible.
 * On exemplar, one has to specify a low value here, because of lack of
 * memory for interactive jobs.
 *
 * Revision 1.2  1996/11/23 02:25:32  milind
 * Fixed several subtle bugs in the converse runtime for convex
 * exemplar.
 *
 * Revision 1.1  1996/07/02 21:22:49  jyelon
 * Initial revision
 *
 * Revision 1.1  1996/06/24 20:40:13  jyelon
 * Initial revision
 *
 * Revision 1.1  1996/06/24 18:26:46  jyelon
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/vars.c,v 1.4 1997/11/26 19:17:21 milind Exp $";

#include <stdio.h>
#include <converse.h>

void Cpm_megacon_ack();

typedef struct vars_chare
{
  int countdown;
  CthThread pending;
}
*vars_chare;

CpmDeclareSimple(vars_chare);
#define CpmPack_vars_chare(x) (0)
#define CpmUnpack_vars_chare(x) (0)

#include "vars.cpm.h"

CtvDeclare(int, ctv1);
CpvDeclare(int, cpv1);
CsvDeclare(int, csv1);

CpmInvokable vars_ack(vars_chare c)
{
  c->countdown--;
  if ((c->countdown==0)&&(c->pending))
    CthAwaken(c->pending);
}

void vars_check_ctv_privacy(vars_chare c)
{
  int me = (size_t)CthSelf();
  CtvAccess(ctv1) = me;
  vars_ack(c);
  CthSuspend();
  if (CtvAccess(ctv1) != me) {
    CmiPrintf("ctv privacy test failed.\n");
    exit(1);
  }
  vars_ack(c);
  CthFree(CthSelf());
  CthSuspend();
}

CpmInvokable vars_set_cpv_and_csv(vars_chare c)
{
  CpvAccess(cpv1) = CmiMyPe();
  if (CmiMyRank() == 0)
    CsvAccess(csv1) = 0x12345678;
  Cpm_vars_ack(CpmSend(0), c);
}

CpmInvokable vars_check_cpv_and_csv(vars_chare c)
{
  if (CpvAccess(cpv1) != CmiMyPe()) {
    CmiPrintf("cpv privacy test failed.\n");
    exit(1);
  }
  if (CsvAccess(csv1) != 0x12345678) {
    CmiPrintf("csv sharing test failed.\n");
    exit(1);
  }
  Cpm_vars_ack(CpmSend(0), c);
}

CpmInvokable vars_control()
{
  struct vars_chare c; CthThread t1,t2;

  t1 = CthCreate(vars_check_ctv_privacy, (void *)&c, 0);
  t2 = CthCreate(vars_check_ctv_privacy, (void *)&c, 0);
  CthSetStrategyDefault(t1);
  CthSetStrategyDefault(t2);

  CthAwaken(t1); CthAwaken(t2);
  c.countdown = 2; c.pending = CthSelf(); CthSuspend();
  
  CthAwaken(t1); CthAwaken(t2);
  c.countdown = 2; c.pending = CthSelf(); CthSuspend();
  
  Cpm_vars_set_cpv_and_csv(CpmSend(CpmALL), &c);
  c.countdown = CmiNumPes(); c.pending = CthSelf(); CthSuspend();
  
  Cpm_vars_check_cpv_and_csv(CpmSend(CpmALL), &c);
  c.countdown = CmiNumPes(); c.pending = CthSelf(); CthSuspend();
  
  Cpm_megacon_ack(CpmSend(0));
}

void vars_init()
{
  Cpm_vars_control(CpmMakeThreadSize(0,0));
}

void vars_moduleinit()
{
  CpmInitializeThisModule();
  CtvInitialize(int, ctv1);
  CpvInitialize(int, cpv1);
  CsvInitialize(int, csv1);
}

