/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: multicast.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1998/02/20 10:22:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: multicast.c,v $
 * Revision 1.1  1998/02/20 10:22:56  jyelon
 * Added multicast test to megacon.
 *
 * Revision 1.3  1997/11/26 19:17:18  milind
 * Fixed some portability bugs due to varying integer and pointer sizes.
 *
 * Revision 1.2  1996/06/24 23:43:42  jyelon
 * *** empty log message ***
 *
 * Revision 1.1  1996/06/24 20:40:13  jyelon
 * Initial revision
 *
 * Revision 1.1  1996/06/24 18:26:46  jyelon
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/multicast.c,v 1.1 1998/02/20 10:22:56 jyelon Exp $";

#include <stdio.h>
#include <converse.h>

void Cpm_megacon_ack();

typedef struct bchare
{
  CmiGroup grp;
  int totalsent;
  int totalreplies;
}
*bchare;

typedef struct mesg
{
  char head[CmiMsgHeaderSizeBytes];
  int reply_pe, reply_ptr;
  int magic;
}
*mesg;

CpvDeclare(int, multicast_recv_idx);
CpvDeclare(int, multicast_reply_idx);

void multicast_recv(mesg m)
{
  if (m->magic != 0x12345678) {
    CmiPrintf("multicast failed.\n");
    exit(1);
  }
  CmiSetHandler(m, CpvAccess(multicast_reply_idx));
  CmiSyncSend(m->reply_pe, sizeof(struct mesg), m);
}

void multicast_start_cycle(bchare c)
{
  struct mesg m; struct mesg *mp; CmiCommHandle h;
  switch (c->totalsent) {
  case 0:
    CmiSetHandler(&m, CpvAccess(multicast_recv_idx));
    m.reply_ptr = (size_t)c; m.reply_pe = CmiMyPe(); m.magic = 0x12345678;
    CmiSyncMulticast(c->grp, sizeof(struct mesg),&m);
    c->totalsent++;
    break;
  case 1:
  case 2:
    mp = (mesg)CmiAlloc(sizeof(struct mesg));
    CmiSetHandler(mp, CpvAccess(multicast_recv_idx));
    mp->reply_ptr = (size_t)c; mp->reply_pe = CmiMyPe();mp->magic = 0x12345678;
    CmiSyncMulticastAndFree(c->grp, sizeof(struct mesg), mp);
    c->totalsent++;
    break;
  case 3:
    free(c);
    Cpm_megacon_ack(CpmSend(0));
  }
}

void multicast_reply(mesg m)
{
  bchare c;
  if (m->magic != 0x12345678) {
    CmiPrintf("multicast failed.\n");
    exit(1);
  }
  c = (bchare)(m->reply_ptr);
  c->totalreplies++;
  if ((c->totalreplies % CmiNumPes())==0) multicast_start_cycle(c);
}

CmiGroup multicast_all()
{
  int i, *pes, npes; CmiGroup grp;
  npes = CmiNumPes();
  pes = (int*)malloc(npes*sizeof(int));
  for (i=0; i<npes; i++) pes[i] = i;
  grp = CmiEstablishGroup(CmiNumPes(), pes);
  free(pes);
  return grp;
}

void multicast_init(void)
{
  bchare c;
  c = (bchare)malloc(sizeof(struct bchare));
  c->grp = multicast_all();
  c->totalsent = 0;
  c->totalreplies = 0;
  multicast_start_cycle(c);
}

void multicast_moduleinit()
{
  CpvInitialize(int, multicast_recv_idx);
  CpvInitialize(int, multicast_reply_idx);
  CpvAccess(multicast_recv_idx) = CmiRegisterHandler(multicast_recv);
  CpvAccess(multicast_reply_idx) = CmiRegisterHandler(multicast_reply);
}






