/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: fibobj.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1997/11/26 19:17:19 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: fibobj.c,v $
 * Revision 1.3  1997/11/26 19:17:19  milind
 * Fixed some portability bugs due to varying integer and pointer sizes.
 *
 * Revision 1.2  1997/04/09 20:19:04  jyelon
 * Increased the size of the test.
 *
 * Revision 1.1  1996/06/24 18:26:46  jyelon
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/megacon/fibobj.c,v 1.3 1997/11/26 19:17:19 milind Exp $";

#include <stdio.h>
#include <converse.h>
#include "fibobj.cpm.h"

/*
 *  Input:    10   11   12   13   14   15   16   17   18   19   20
 *  Output:   55   89  144  233  377  610  987 1597 2584 4181 6765
 */

#define FIB_INPUT 17
#define FIB_OUTPUT 1597

void Cpm_megacon_ack();

typedef struct fibobj_chare
{
  int ppe, ppos;
  int count, total;
}
*fibobj_chare;

CpmDestination CpmLDB()
{
  int pe = ((rand()&0x7FFFFFFF)>>8) % CmiNumPes();
  return CpmSend(pe);
}

CpmInvokable fibobj_result(int n, int cpos)
{
  fibobj_chare c = (fibobj_chare)cpos;
  c->total += n; c->count ++;
  if (c->count == 2) {
    if (c->ppe >= 0)
      Cpm_fibobj_result(CpmSend(c->ppe), c->total, c->ppos);
    else {
      if (c->total != FIB_OUTPUT) {
	CmiPrintf("Fib: results incorrect.\n");
	exit(1);
      }
      Cpm_megacon_ack(CpmSend(0));
    }
    free(c);
  }
}

CpmInvokable fibobj_calc(int n, int ppe, int ppos)
{
  if (n<2) Cpm_fibobj_result(CpmSend(ppe), n, ppos);
  else {
    fibobj_chare c = (fibobj_chare)malloc(sizeof(struct fibobj_chare));
    c->ppe = ppe, c->ppos = ppos; c->count=c->total=0;
    Cpm_fibobj_calc(CpmLDB(), n-1, CmiMyPe(), (size_t)c);
    Cpm_fibobj_calc(CpmLDB(), n-2, CmiMyPe(), (size_t)c);
  }
}

void fibobj_init()
{
  fibobj_chare c = (fibobj_chare)malloc(sizeof(struct fibobj_chare));
  c->ppe = -1, c->ppos = FIB_INPUT; c->total=0; c->count=1;
  Cpm_fibobj_calc(CpmLDB(), FIB_INPUT, CmiMyPe(), (size_t)c);
}

void fibobj_moduleinit()
{
  CpmInitializeThisModule();
}



