/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: latencyBWtest.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1998/01/23 22:27:45 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * Send a message around a ring, to measure message latency and bandwidth
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: latencyBWtest.c,v $
 * Revision 1.6  1998/01/23 22:27:45  milind
 * replaced timer with walltimer in latencyBWTest.
 *
 * Revision 1.5  1998/01/16 18:02:58  milind
 * Fixed Ctv bug on shared memory machines.
 * Made latencyBWtest conformant with Converse.
 * Added high resolution timers to Origin2000.
 * Removed starvation from Origin Pthreads version.
 *
 * Revision 1.4  1998/01/15 22:25:49  milind
 * Fixed bugs in latencyBWtest and optimized SP3 communication.
 *
 * Revision 1.3  1997/03/19 04:28:24  jyelon
 * Restructured main
 *
 * Revision 1.2  1996/11/23 02:25:30  milind
 * Fixed several subtle bugs in the converse runtime for convex
 * exemplar.
 *
 * Revision 1.1  1996/02/05 15:05:49  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/latencyBWtest/latencyBWtest.c,v 1.6 1998/01/23 22:27:45 milind Exp $";

#include "converse.h"
#include <stdio.h>

/* flag to turn content checking on or off */

#define CHECKCONTENTS 0

CpvDeclare(int, hndl_id);
CpvDeclare(int, sendPE);
CpvDeclare(int, MSG_SIZ);
CpvDeclare(int, total_messages);
CpvDeclare(int, num_messages);
CpvDeclare(double, start_time);

void hndlr(int *);
void ConverseRing(int, int);

#if CHECKCONTENTS
void setMessage(int *, int);
int checkMessage(int *, int);
#endif

#define TSCOUNT 4

void lbw_main(argc, argv)
    int argc; char **argv;
{
  CpvInitialize(int, hndl_id);
  CpvInitialize(int, sendPE);
  CpvInitialize(int, MSG_SIZ);
  CpvInitialize(int, total_messages);
  CpvInitialize(int, num_messages);
  CpvInitialize(double, start_time);
  CpvAccess(hndl_id) = CmiRegisterHandler(hndlr);
  ConverseRing(1<<8,1024);
  CsdScheduler(-1); 
  ConverseRing(1<<10,512);
  CsdScheduler(-1); 
  ConverseRing(1<<12,256);
  CsdScheduler(-1); 
  ConverseRing(1<<14,128);
  CsdScheduler(-1); 
  ConverseRing(1<<16,64);
  CsdScheduler(-1); 
  ConverseRing(1<<18,32);
  CsdScheduler(-1); 
  ConverseRing(1<<20,16);
}

void main(int argc, char **argv)
{
  ConverseInit(argc,argv,lbw_main,0,0);
}



void hndlr(msg)
int *msg;
{
  double per_ping, msg_time;

  CmiGrabBuffer(&msg);
  CpvAccess(num_messages)++;

#if CHECKCONTENTS
  if(!checkMessage(msg, CpvAccess(MSG_SIZ)-CmiMsgHeaderSizeBytes)) {
    CmiPrintf("Message Contents Corrupted.\n");
    exit(1);
  }
#endif

  if(CpvAccess(num_messages) < CpvAccess(total_messages)) {
      if(CpvAccess(num_messages) == TSCOUNT)
	CpvAccess(start_time) = CmiWallTimer();
      CmiSyncSendAndFree(CpvAccess(sendPE), CpvAccess(MSG_SIZ), msg);
  } else {
    if(CmiMyPe() != 0)
      CmiSyncSendAndFree(CpvAccess(sendPE), CpvAccess(MSG_SIZ), msg);
    else {
      msg_time =  CmiWallTimer()-CpvAccess(start_time);
      per_ping =  msg_time/(CmiNumPes()*(CpvAccess(total_messages)-TSCOUNT));
      CmiPrintf("%d\t%.19lf\n", CpvAccess(MSG_SIZ)-CmiMsgHeaderSizeBytes, per_ping);
    }
    CsdExitScheduler();
  }
}

#if CHECKCONTENTS
void setMessage(int *msg, int size)
{
  int i;

  msg = (int *) ((char *)msg + CmiMsgHeaderSizeBytes);
  for(i=0;i<(size/sizeof(int));i++)
    msg[i] = i+13456;
}

int checkMessage(int *msg, int size)
{
  int i;

  msg = (int *) ((char *)msg + CmiMsgHeaderSizeBytes);
  for(i=0;i<(size/sizeof(int));i++)
    if(msg[i]!= i+13456)
      return 0;
  return 1;
}
#endif

void ConverseRing(size, repetitions)
int size, repetitions;
{
  int i, *my_msg;
  
  CpvAccess(total_messages) = TSCOUNT + repetitions;
  CpvAccess(MSG_SIZ) = size+CmiMsgHeaderSizeBytes;
  CpvAccess(num_messages) = 0;
  CpvAccess(sendPE) = (CmiMyPe() + 1) % CmiNumPes();

  if(CmiMyPe() == 0) { 
    my_msg = (int *)CmiAlloc(CpvAccess(MSG_SIZ));
#if CHECKCONTENTS
    setMessage(my_msg, size);
#endif
    CmiSetHandler(my_msg, CpvAccess(hndl_id));
    CmiSyncSendAndFree(CpvAccess(sendPE), CpvAccess(MSG_SIZ), my_msg);
  }
}
