/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ntctest.C,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1998/03/16 20:55:07 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * This is a program to test several aspects of the interface-translated
 * version of charm.  Here are some of the things it tests:
 * 1. Creating chare groups (BOCs)
 * 2. Creating chares
 * 3. Creating chares with virtual IDs
 * 4. Creating and sending messages declared in your module
 * 5. Creating and sending messages declared in another module
 * 6. Creating and sending messages declared in a module containing no code
 * 7. Quiescence detection
 *
 * Here are some things it doesn't test.
 * 1. Read-only vars
 * 2. Accumulator
 * 3. Monotonics
 * 4. Write-once vars
 * 5. Message packing
 * 6. Prioritized execution
 *
 * I don't know if some of the items in the second list are even supported.
 * I will attempt to move items from the second list into the first list.
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ntctest.C,v $
 * Revision 1.4  1998/03/16 20:55:07  milind
 * Fixed include files bugs.
 *
 * Revision 1.3  1998/02/13 23:52:40  pramacha
 * Modified to incorporate specifying Message Types in EP's
 *
 * Revision 1.2  1998/02/12 23:56:47  jdesouza
 * Corrected the return type of quiescence_reached() and quit_when_done()
 * to void.
 *
 * Revision 1.1  1996/06/27 22:07:16  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/itc++test/ntctest.C,v 1.4 1998/03/16 20:55:07 milind Exp $";

#include <stdio.h>
#include "charm++.h"

#include "ntctest.top.h"
#include "ntctest.h"
#include "ntctest.bot.h"

#include "Hello1.top.h"
#include "Hello2.top.h"
#include "Hello3.top.h"

main::main(int argc, char**argv)
{ 
  int pramacha;

  msg_count = 0;
  ChareMsg *chare_msg = new (MsgIndex(ChareMsg)) ChareMsg;

  InitMsg *msg1 = new (MsgIndex(InitMsg)) InitMsg;
  chare_msg->hello1 = new_group(Hello1,InitMsg,msg1);

  InitMsg *msg2 = new (MsgIndex(InitMsg)) InitMsg;
  chare_msg->hello2 = new_group(Hello2,InitMsg,msg2);

  InitMsg *msg3 = new (MsgIndex(InitMsg)) InitMsg;
  new_chare2(Hello3,InitMsg,msg3,&chare_msg->hello3,CK_PE_ANY);

  InitMsg *msg4 = new (MsgIndex(InitMsg)) InitMsg;
  new_chare(ChareExitTest,InitMsg,msg4);

  CSendMsgBranch(Hello1, other_chares, ChareMsg,chare_msg, chare_msg->hello1, 0);
  CStartQuiescence(GetEntryPtr(main,quiescence_reached,QuiescenceMessage),mainhandle);
}

void
main::quit_when_done(DoneMsg *msg)
{
  msg_count++;
  CPrintf("Message %d received\n",msg_count);

  delete msg;
}

void
main::quiescence_reached(QuiescenceMessage *msg)
{
  int expected_count = 6*CmiNumPes()+4;

  CPrintf("%d messages received, quiescence reached\n",msg_count);
  if (expected_count == msg_count)
    CPrintf("SUCCESS: Message count correct\n");
  else
    CPrintf("FAIL: %d messages expected\n",expected_count);
    
  CharmExit();
  delete msg;
}
