/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Hello3.C,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1998/03/16 20:55:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * This file contains two chares, one which responds to several message
 * types to exercise the various variations on send, and a second which
 * sends one message back to the main chare, and then calls ChareExit()
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: Hello3.C,v $
 * Revision 1.3  1998/03/16 20:55:04  milind
 * Fixed include files bugs.
 *
 * Revision 1.2  1998/02/13 23:52:38  pramacha
 * Modified to incorporate specifying Message Types in EP's
 *
 * Revision 1.1  1996/06/27 22:07:16  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/charm/pgms/itc++test/Hello3.C,v 1.3 1998/03/16 20:55:04 milind Exp $";

#include <stdio.h>
#include "charm++.h"

#include "Hello3.top.h"
#include "Hello3.h"

#include "ntctest.top.h"
#include "ntctest.h"
#include "Hello1.h"
#include "Hello2.h"
#include "Msg3.h"

#include "Hello3.bot.h"

//======================================================================
Hello3::Hello3(InitMsg *msg)
{
  CPrintf("Hello from Hello3, processor %d\n",CMyPeNum()) ;
  delete msg;
}

//----------------------------------------------------------------------
void Hello3::recv_msg1(Msg1 *msg) 
{
  DoneMsg *done_msg = new (MsgIndex(DoneMsg)) DoneMsg;

  CSendMsg(main,quit_when_done,DoneMsg,done_msg, &mainhandle);
  delete msg;
}

//----------------------------------------------------------------------
void Hello3::recv_msg2(Msg2 *msg) 
{
  DoneMsg *done_msg = new (MsgIndex(DoneMsg)) DoneMsg;

  CSendMsg(main,quit_when_done,DoneMsg,done_msg, &mainhandle);
  delete msg;
}

//----------------------------------------------------------------------
void Hello3::recv_msg3(Msg3 *msg) 
{
  DoneMsg *done_msg = new (MsgIndex(DoneMsg)) DoneMsg;

  CSendMsg(main,quit_when_done,DoneMsg,done_msg, &mainhandle);
  delete msg;
}

//======================================================================
ChareExitTest::ChareExitTest(InitMsg *msg)
{
  DoneMsg *done_msg = new (MsgIndex(DoneMsg)) DoneMsg;

  CPrintf("ChareExitTest calling ChareExit\n");
  CSendMsg(main,quit_when_done,DoneMsg,done_msg, &mainhandle);
  ChareExit();
  delete msg;
}


