#include "charm++.h"
#include "pgm.top.h"

#include <stdio.h>

class InitMsg : public comm_object
{
public:
  int x;
};

class main : public chare_object
{
  int count;
public:
  main(int argc, char **argv)
  {
    // futuresModuleInit();
    InitMsg *message = new (MsgIndex(InitMsg)) InitMsg;	
    new_group (BOC1, InitMsg, message);
    CkExit();
  }
};

class BOC1: public groupmember
{
public:

  BOC1(InitMsg *m) {
    if (CMyPe() == 0)
      CSendMsgBranch( BOC1, ep0, InitMsg, m, thisgroup, 0);
  }

  void ep0(InitMsg* m) //   This is a threaded entry method
  {
    InitMsg * result;
    result = (InitMsg*) CRemoteCallBranchFn(GetEntryPtr(BOC1,ep1, InitMsg),
					    m, thisgroup, 0);
    CPrintf(" [%d] Ep0:Got result.\n",CmiMyPe());
  }

  InitMsg *ep1(InitMsg* m) //   This is a threaded entry method
  {
      InitMsg * result;
      result = (InitMsg*) CRemoteCallBranchFn(GetEntryPtr(BOC1,ep2, InitMsg),
					      m, thisgroup, 0);
      CPrintf("Ep1: Got result=%d from ep2. sending it up to BOC1.\n",
	      result->x);
      return(result);
  }

  InitMsg *ep2(InitMsg * m)  // not a threaded ep
  {
    m->x = 3456;
    CkPrintf(" finishing ep2\n");
    return(m);
  }
};

#include "pgm.bot.h"
