/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.p,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 2.4 $	$Date: 1998/03/16 20:54:44 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.p,v $
 * Revision 2.4  1998/03/16 20:54:44  milind
 * Fixed include files bugs.
 *
 * Revision 2.3  1997/02/06 19:51:08  jyelon
 * I have no idea what I changed.
 *
 * Revision 2.2  1995/10/31 16:45:51  milind
 * Removed duplicate declaration of CmiTimer.
 *
 * Revision 2.1  1995/06/29  20:41:36  narain
 * Cktimer change
 *
 * Revision 2.0  1995/06/01  20:59:37  brunner
 * Reorganized directory structure
 *
 * Revision 1.1  1994/10/14  21:37:28  brunner
 * Initial revision
 *
 ***************************************************************************/

module TABLE {


/************************************************************************/
/* Counting the number of fib of n identical objects into K piles       */
/* Using dynamic tables to avoid duplication			        */
/************************************************************************/

#include "charm-inc.h"

readonly int grainSize, topFib;
table fibtbl;

#define CkTimer() ((int)(CmiTimer()*1000))
#define CkUTimer() ((int)(CmiTimer()*1000000))
	      
message { 
	int n;
	ChareIDType parentID;
	EntryPointType sendToEp;
} 
ProblemMsg;

message {
	int fib;
} 
SolutionMsg;

chare main {
	int k;
entry CharmInit:
{  
	ProblemMsg * pMsg ;

	CPrintf("Enter n: ");
	CScanf("%d", &topFib);
        CPrintf("Entered n: %d\n", topFib);
	ReadInit(topFib);
	CPrintf("Enter grain-size: ");
	CScanf("%d", &grainSize);
        CPrintf("Entered grain-size: %d\n", grainSize);
        ReadInit(grainSize); 

	pMsg = (ProblemMsg *) CkAllocMsg( ProblemMsg);
	pMsg->n = topFib;
	pMsg->sendToEp = main@Solution;
	MyChareID( & (pMsg->parentID) );
	CreateChare(fib, fib@InitSubGoal, pMsg);  
}

entry Solution:  (message SolutionMsg * msg)
{ 
	CPrintf("The answer is: %d at %d milli-seconds.\n", msg->fib,
		 CkTimer());
	CkExit();   
}
}

chare fib 
{
	ChareIDType parent;
	EntryPointType parentEP;
	int total, count;
	int n,k;
	int store;
	int key;

entry InitSubGoal: (message ProblemMsg *msg)
{ 
	ChareIDType myID;

 CkPrintf("Init Subgoal: %d\n", msg->n);
	parent = msg->parentID;     /* struct copy. */
	parentEP = msg->sendToEp;
	n = msg->n; 
	store = 1;
	key = n ;
	MyChareID(&myID);
	TblFind(fibtbl, key, TblChecked, &myID, TBL_WAIT_AFTER_FIRST); 
	CkFreeMsg(msg);
}

entry TblChecked: (message TBL_MSG *msg)
{ 
	ProblemMsg *msg1, *msg2;
	int temp;
        static Fib();

 CkPrintf("Table Checked: %d\n", msg->data);
	if (msg->data != 0)
	{
		temp = *((int *) msg->data);
		store = 0;
		PrivateCall(sendResponse(temp));
	}
	else 
	{
		if (n  < ReadValue(grainSize)) 
			PrivateCall(sendResponse( Fib(n)) );
		else       /* Otherwise, start parallel subcomputations. */
		{
			total = 0; 
			count = 2;
			msg1 =  (ProblemMsg *) CkAllocMsg( ProblemMsg );
			msg2 =  (ProblemMsg *) CkAllocMsg( ProblemMsg );
			msg1->n = n-1;      
			msg1->sendToEp = fib@Response;
			MyChareID( &(msg1->parentID) );
			CreateChare(fib, InitSubGoal, msg1);   /* fib(n-1,k-1) */
			msg2->n = n-2; 
			MyChareID( &(msg2->parentID) );
			msg2->sendToEp = fib@Response;
			CreateChare(fib, InitSubGoal, msg2);    /* fib(n-k,k) */
		}
	}
	CkFreeMsg(msg);
}

entry Response: (message SolutionMsg * msg)
{
 CkPrintf("Response: %d\n", msg->fib);
	total += msg->fib;
	CkFreeMsg(msg);
	if (--count == 0)
		PrivateCall(sendResponse(total));
}

private sendResponse(value)
int value;
{
	SolutionMsg * resp;
	resp = (SolutionMsg *) CkAllocMsg( SolutionMsg);
	resp->fib = value;
	SendMsg(parentEP, resp, &parent);
	if (store) TblInsert(fibtbl, key, &value, sizeof(value), -1, (void *)0);
}
}

Fib(n)
int n;
{ 
	if (n<2)
		return(n);
	else
		return(Fib(n-1)+Fib(n-2));
}
}
