/* @TITLE "write - write patterns to file" */
/*
 * write.c - write the pattern that was generated to the file. 
 *
 * David Kotz 4/89, 8/90
 */

static char rcsid[] = "$Id: write.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"

static void WriteMyString();
static void WriteOneString();
static void WriteString();

static unsigned int *location; /* atomic file position */
static short *position;		/* atomic string choice */

extern FILE *fopen();

/* @SUBTITLE "CreateFile: Set up the pattern file" */
void
CreateFile(name, head)
	char *name;			/* file name */
	P_HEAD *head;			/* contains all header info we need */
{
    FILE *fp;

    if ((fp = fopen(name, "w")) == (FILE *)NULL) {
	   printf("Could not create file '%s'\n", name);
	   exit(1);
    }

    if (head->global)
	 head->nprocs = 1;		/* enforce this rule */

    fputc(PATTERN_MAGIC, fp);
    fputc(PATTERN_FORMAT_VERSION, fp);
    fwrite(head, sizeof(P_HEAD), 1, fp);

    fclose(fp);

    /* set up to be re-opened later */
    PatternFileInUse(name, "r+");
}

/* @SUBTITLE "WritePattern: Write a pattern to file" */
void
WritePattern()
{
    /* note that STRING_POS(pat_procs) is location of first string data */
    AllocateShare(location, unsigned int, STRING_POS(pat_procs));

    if (IsSharedPattern())
	 GenOnI(WriteOneString, pat_procs);
    else if (my_refs != NULL && my_refs->global) /* global */
	 WriteString(my_refs, 0);
    else if (my_refs != NULL)	{ /* local */
	   AllocateShareZero(position, short);
	   GenTaskForEachProc(WriteMyString, 0);
	   UsFree(position);
    }

    UsFree(location);
}

static void 
WriteMyString()
{
    int pos = Atomic_add(position, 1);
    WriteString(my_refs, pos);
}

static void 
WriteOneString(dummy, index)
	int dummy;
	int index;
{
    UsePattern(index);
    WriteString(my_refs, index);
}

/* @SUBTITLE "WriteString: Write a single string" */
/* can be called externally, possibly in parallel. */
static void
WriteString(refs, pos)
	REFS *refs;
	int pos;
{
    P_STRING string;		/* one string header */
    unsigned long mysize;

    OpenPatternFile();

    /* compute size of our string */
    mysize = (refs->nchunks) * sizeof(ONEREF)
	 + (refs->nportions) * sizeof(unsigned int);

    /* build string header */
    string.numrefs = refs->nchunks;
    string.numportions = refs->nportions;
    string.portion_limit = refs->portion_limit;
    string.location = Atomic_add_long(location, mysize);

    /* write string header */
    fseek(pattern_fp, STRING_POS(pos), 0);
    fwrite(&string, sizeof(string), 1, pattern_fp);

    /* write the string */
    fseek(pattern_fp, string.location, 0);
    fwrite(refs->chunks, sizeof(ONEREF), refs->nchunks, 
		 pattern_fp);
    fwrite(refs->portions, sizeof(unsigned int), refs->nportions, 
		 pattern_fp);

    ClosePatternFile();
}
