/* @SUBTITLE "Compute the optimum portion skip for LPS" */
int
FindLPSPortionSkip(ndisks, portionLength, nprocs)
	int ndisks; 
	int portionLength;		/* in blocks */
	int nprocs;
{
    int skip;

    for (skip = portionLength; gcd(skip, ndisks) > 1; skip++)
	 ;

    return(skip * nprocs);
}

/* For testing, compile with
 *    cc -g -DTEST pskip.c gcd.o -o pskip
 */
#ifdef TEST
#include <stdio.h>

main()
{
    int nd, pl, np;
    char line[BUFSIZ];

    printf("pskip program\n");

    while (!feof(stdin)) {
	   printf("Input ndisks, portion length (in blocks), and nprocs, separated by commas:\n--> ");
	   if (fgets(line, BUFSIZ, stdin) == (char *)NULL)
		break;
	   sscanf(line, "%d,%d,%d\n", &nd, &pl, &np);
	   printf("  pskip(%d,%d,%d) = %d\n", nd, pl, np, 
			FindLPSPortionSkip(nd,pl,np));
    }
}
#endif TEST
