/* @TITLE "print - print reference strings for debugging or analysis" */
/*
 * print.c - print the reference strings to stdout.
 */

static char rcsid[] = "$Id: print.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include <refs.h>
#include <pattern.h>

void PrintRef();			/* the usual calling point */
void PrintOneRef();			/* can call this too */
static void PrintLocalRefs();
static void PrintLocalRef();

static boolean verbose;

extern int pat_procs;		/* from read.c */

/* @SUBTITLE "PrintRef: Print ref string(s)" 
 * handles local, global, and shared cases
 */
void
PrintRef(verb)
	boolean verb;			/* verbose */
{
    int r;

    if (IsSharedPattern()) {
	   for (r = 0; r < pat_procs; r++) {
		  UsePattern(r);
		  PrintOneRef(r, verb);
	   }
    } else 
	 if (my_refs->global)
	   PrintOneRef(0, verb);
	 else
	   PrintLocalRefs(verb);
}

/* @SUBTITLE "PrintLocalRef[s]: Print ref string for local pattern" */
static void
PrintLocalRefs(verb)
	boolean verb;
{
    short *turn;

    verbose = verb;
    Share(&verbose);
    AllocateShareZero(turn, short);

    GenTaskForEachProc(PrintLocalRef, turn);

    UsFree(turn);
}

static void
PrintLocalRef(turn)
	short *turn;
{
    while (*turn != UsProc_Node)
	 UsWait(100);
    PrintOneRef(UsProc_Node, verbose);
    Atomic_add(turn, 1);
}

/* @SUBTITLE "PrintOneRef: Does the printing of one ref string" */
void
PrintOneRef(proc, verbose)
	int proc;
	boolean verbose;
{
    int s,p;
    boolean portions;

    printf("\nReference string for proc %2d\n", proc);
    if (my_refs == NULL) {
	   printf ("NULL\n");
	   return;
    }

    printf("%s pattern: ", my_refs->global ? "GLOBAL" : "LOCAL");
    printf("%d portions, %d chunks\n", my_refs->nportions, my_refs->nchunks);
    if (my_refs->portion_limit)
	 printf("Prefetching limited to portion\n");

    if (verbose) {
	   portions = my_refs->nportions != 0;

	   for (s=0, p=0; s < my_refs->nchunks; s++) {
		  printf("%c%u+%u(%.1f)\t",
			    my_refs->chunks[s].write ? 'W' : 'R',
			    my_refs->chunks[s].offset,
			    my_refs->chunks[s].length,
			    (float)(my_refs->chunks[s].comptime) / 100.);
		  if (portions && s == my_refs->portions[p]) {
			 printf("PORTION\t");
			 p++;
		  }
	   }
	   printf("\n");
    }

    printf("\n");
}

