/* @TITLE "open - open pattern file" */
/*
 * open.c - open the pattern file if not already.
 *
 * David Kotz 4/89
 */

static char rcsid[] = "$Id: open.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"

/* These are shared to give access to all processors 
 * and also provides a memory of what pattern is loaded 
 */
static char cur_fname[BUFSIZ] = ""; /* (copy shared) */
static char cur_mode[10];	/* (copy shared) */

FILE *pattern_fp = NULL;	/* the current pattern file (process private) */

/* @SUBTITLE "PatternFileInUse: define the file to be used" */
void
PatternFileInUse(name, mode)
	char *name;			/* name of file */
	char *mode;			/* access mode (eg "r", "r+") */
{
    strcpy(cur_fname, name);
    strcpy(cur_mode, mode);

    ShareBlk(cur_fname, strlen(cur_fname)+1);
    ShareBlk(cur_mode, strlen(cur_mode)+1);
}

/* @SUBTITLE "SamePatternFile: named file is same as current?" */
boolean
SamePatternFile(name)
	char *name;			/* name of file */
{
    return(*cur_fname != '\0' && strcmp(name, cur_fname) == 0);
}

/* @SUBTITLE "OpenPatternFile: open the file again" */
void
OpenPatternFile()
{
    extern FILE *fopen();

    /* already open? */
    if (pattern_fp != (FILE *)NULL)
	 return;

    if ((pattern_fp = fopen(cur_fname, cur_mode)) == (FILE *)NULL) {
	   printf("Cannot open file '%s' on proc %d with mode %s\n",
			cur_fname, UsProc_Node, cur_mode);
	   exit(1);
    }
}

/* @SUBTITLE "ClosePatternFile: close the pattern file here" */
void
ClosePatternFile()
{
    if (pattern_fp != (FILE *)NULL) {
	   fclose(pattern_fp);
	   pattern_fp = (FILE *)NULL;
    }
}
