/* @TITLE "makecomp - generate comp pattern from plain pattern" */
/*
 * makecomp.c - Builds a pattern file to be used by the driver, 
 * based on another pattern file, but with "computation" added.
 * WORK IS DONE IN PLACE.
 *
 * In the local case, the work may be done in parallel (using any
 * available processors); in the global case,
 * the work is done only on the main processor and the reference string
 * is shared. The file itself may be written in parallel.
 *
 * David Kotz 5/89
 */

static char rcsid[] = "$Id: makecomp.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

/* @SUBTITLE "Declarations" */

/* GLOBAL DATA */
char filename[P_FILENAMELEN+1];	/* filename */
int computation;			/* computation time per chunk */
boolean computation_fixed;	/* computation is fixed amount? */

/* LOCAL FUNCTIONS */
static void AddComp();
static void ReadInfo();
static void ShareInfo();

/* @SUBTITLE "main program" */
main(argc, argv)
	int argc;
	char **argv;
{
    P_HEAD *head;			/* header for file */

    InitializeUs();			/* so we can use parallelism, if there */

    ReadInfo(argc, argv);	/* read pattern parameters */

    ShareInfo();			/* share parameters */

    head = OpenPattern(filename, "r+"); /* open the file */
    if (head == (P_HEAD *)NULL)
	 exit(1);

    /* We use GenOnI so we can use any processors we have */
    GenOnI(AddComp, head->nprocs);

    head->computation = computation;
    head->computation_fixed = computation_fixed;
    RewriteHead(head);

    /* close file everywhere */
    ClosePattern();

    printf("File %s complete\n", filename);
}

/* @SUBTITLE "AddComp: Add computation to a pattern" */
static void
AddComp(dummy, p)
	int dummy; 
	int p;				/* which pattern to do? */
{
    srandom(p * 1000 + GetRtc()); /* seed the random number generator */
    ReadPattern(p);			/* read pattern p */
    genComputation();		/* add computation */
    RewritePattern();		/* write it back */
}

/* @SUBTITLE "ReadInfo: Read in the various pattern parameters" */

#define STYLE_LEN 10

static void
ReadInfo(argc, argv)
	int argc;
	char **argv;
{
    char style[STYLE_LEN+1];
    char line[11];

    if (--argc > 0) {
	   strncpy(filename, *++argv, P_FILENAMELEN);
	   printf("Filename is '%s'\n", filename);
    } else {
	   printf("Name of pattern FILE (%d chars): ", P_FILENAMELEN);
	   ReadString(filename, "Filename", P_FILENAMELEN);
    }	   
    if (*filename == '\0') {
	   printf("Must specify filename\n");
	   exit(1);
    }

    if (--argc > 0) {
	   computation = atoi(*++argv);
	   printf("Computation is %u msec per chunk\n", computation);
    } else {
	   printf("Amount of computation per chunk: ");
	   ReadNumber("Computation per Chunk, in msec", &computation);
    }

    if (computation > 0) {
	   if (--argc > 0) {
		  strncpy(line, *++argv, 10);
		  printf("Computation fixed(f) or (a) is: %c\n", *line);
	   } else {
		  printf("Is %u msec the average(a), or fixed amount(f)? ", 
			    computation);
		  ReadString(line, 10, "Computation type");
	   }
	   switch (*line) {
		  case 'a':
		  case 'A': {
			 computation_fixed = FALSE;
			 break;
		  }
		  case 'f':
		  case 'F': {
			 computation_fixed = TRUE;
			 break;
		    }
		  default: {
			 printf("Bad computation type\n");
			 exit(1);
		  }
	   }
    } else
	 computation_fixed = TRUE;
}

/* @SUBTITLE "ShareInfo: Share the pattern parameters" */
static void
ShareInfo()
{
    Share(&computation);
    Share(&computation_fixed);
}

