/* @TITLE "gencomp - add computation to pattern" */
/*
 * gencomp.c - add computation to a pattern
 *
 * David Kotz 4/89
 */

static char rcsid[] = "$Id: gencomp.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

void
genComputation()
{
    int s;				/* chunk number */
    double time;			/* time in msec */
    int ustime;			/* UsWait time units */
    int chunks = my_refs->nchunks;
    extern double exponential();

    if (!computation_fixed)	{	/* computation time */
	   for (s = 0; s < chunks; s++) {
		  do
		    time = exponential(1.0 / (double)computation);
		  while (time > 5 * computation); /* don't be unreasonable */
		  ustime = (int)(time * 1000 / 10 + 1);
		  my_refs->chunks[s].comptime = ustime;
	   }
    } else {
	   ustime = computation * 1000 / 10;
	   for (s = 0; s < chunks; s++)
		my_refs->chunks[s].comptime = ustime;
    }
}

