/* @TITLE "genWHOLE: generators for whole-file patterns" */
/* genWHOLE.c: Pattern for testing RAPIDFILEs. This pattern has processes
 * read the entire file in order. Actually, it reads the first 'chunks'
 * chunks of the file. The local patterns each read every chunk, the global
 * patterns cooperate to read every chunk.
 *
 *  5/22/89 - added LW1 pattern
 */

static char rcsid[] = "$Id: genWHOLE.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

static void genForProc();

static boolean all_nodes;

/* @SUBTITLE "gen[GL]W" (Sequential) primary control" */
void
genLW()
{
    filesize = (unsigned) chunks * chunksize;
    Share(&filesize);
    printf("File size is %u bytes\n", filesize);
    all_nodes = TRUE;
    Share(&all_nodes);
    generate(FALSE, FALSE, genForProc);	/* local pattern, no portions */
}

/* like LW, but only one processor reads the file */
void
genLW1()
{
    filesize = (unsigned) chunks * chunksize;
    Share(&filesize);
    printf("File size is %u bytes\n", filesize);
    all_nodes = FALSE;
    Share(&all_nodes);
    generate(FALSE, FALSE, genForProc);	/* local pattern, no portions */
}

void
genGW()
{
    filesize = (unsigned) chunks * chunksize;
    Share(&filesize);
    printf("File size is %u bytes\n", filesize);
    all_nodes = TRUE;		/* actually, irrelevant here */
    Share(&all_nodes);
    generate(TRUE, FALSE, genForProc); /* global pattern, no portions */
}

/* @SUBTITLE "genForProc: Actual construction of pattern" */
/* Runs in parallel for local pattern. */

static void
genForProc(index)
	int index;
{
    int s;
    double exponential();

    if (all_nodes || index == 0) {
	   for (s = 0; s < chunks; s++)
		AddRef(s, (unsigned) s*chunksize, (unsigned) chunksize, writes);
	   
	   /* Now add computation time to each chunk */
	   genComputation();
    } else {
	   /* for LW1, other processors do nothing */
	   my_refs->nchunks = 0;
	   free(my_refs->chunks);
	   my_refs->chunks = NULL;
    }
    
    my_refs->cur_portion_end = my_refs->nchunks - 1;
    my_refs->portion_limit = FALSE;
}
