/* @TITLE "io.c - SIMULATED I/O simulation library" */
/* io.c (SIMULATED): 
 *    Simulates real I/O by sleeping - does the I/O to RAM objects.
 *
 * FUNCTIONS:
 *  Completely unaware of RAPID internals
 *   io_init, io_init_global
 *   io_open
 *   io_read, io_readwait
 *   io_write, io_writewait
 *   io_close
 *  These last three know about inodes:
 *   io_touch
 *
 * David Kotz   April 1988
 */

#include <stdio.h>
#include <usdfk.h>

/* @SUBTITLE "io_init_global" */
/*	Global initialization for I/O handler - call on primary  processor.
 * Can be called many times, but no files should be open when called.
 *
 * Depends on Uniform System.
 */
/* ARGSUSED */
void
io_init_global(n)
	int n;				/* number of disks */
{
}

/* @SUBTITLE "io_getstat, io_clearstat" */
/*	Read, Clear disk statistics. */
void
io_getstat(util, idletime, waittime)
	float *util;			/* disk utilization (fraction [0,1]) */
	float *idletime;		/* total idle time in msec */
	float *waittime;		/* average wait time in msec */
{
    *idletime = 0;
    *util = 0;
    *waittime = 0;
}

void
io_clearstat()
{
}

/* @SUBTITLE "io_init: Initialization for I/O handler" */
/* call on each processor */

void
io_init()
{
}

/* @SUBTITLE "io_open: open a file" */
/* ARGSUSED */
void
io_open(filename, flags)
	char *filename;		/* file to open */
	int flags;			/* access code to use (a la Unix) */
{
}

/* @SUBTITLE "io_read: read from a file" */
/*	Queue a read on the appropriate disk from the given position in the file.
 * Returns the time when the I/O should be finished.
 */
/* ARGSUSED */

TICS
io_read(oid, disk_addr, size)
	char *oid;				/* frame object */
	unsigned int disk_addr;	/* disk address */
	unsigned int size;		/* size of frame */
{
}

/* @SUBTITLE "io_readwait: read and wait" */
/*	Queue a read on the appropriate disk from the given position in the file.
 * Waits for the I/O to complete.
 */

/* ARGSUSED */
void
io_readwait(oid, disk_addr, size)
	char *oid;				/* frame object */
	unsigned int disk_addr;	/* disk address */
	unsigned int size;		/* size of frame */
{
}

/* @SUBTITLE "io_write: write to a file" */
/*	Queue a write on the appropriate disk to the given position in the file.
 * Returns the time when the I/O should be finished.
 */

/* ARGSUSED */
TICS
io_write(oid, disk_addr, size)
	char *oid;			/* frame object */
	unsigned int disk_addr;	/* disk address */
	unsigned int size;		/* size of frame */
{
}

/* @SUBTITLE "io_writewait: write and wait" */
/*	Queue a write on the appropriate disk to the given position in the file.
 * Waits for the I/O to complete.
 */

/* ARGSUSED */
void
io_writewait(oid, disk_addr, size)
	char *oid;				/* frame object */
	unsigned int disk_addr;	/* disk address */
	unsigned int size;		/* size of frame */
{
}

/* @SUBTITLE "io_close: close a file" */
/*	Close a file. */

/* ARGSUSED */
void
io_close()
{
}
