/* @TITLE "init.c - initialize system (SIMULATED)" */
/* init.c: RAPID initialization routines. Includes:
 *
 *        InitializeRAPIDSystem() 
 */

/* INCLUDES */

#include <stdio.h>
#include <usdfk.h>
#include "rapidelog.h"
#include "io.h"

/* LOCAL FUNCTIONS */

static void InitElogs();
static void InitializeRAPIDSystemAux();

/* @SUBTITLE "InitializeRAPIDSystem" */
void
InitializeRAPIDSystem ()
{
    void InitializeRAPIDSystemAux();
    
    InitElogs();

    /* Perform the initialization on each US process. */
    
    GenTaskForEachProc (InitializeRAPIDSystemAux, 0);
}

/* parallel */
static void	
InitializeRAPIDSystemAux()
{
    io_init();
}

/* @SUBTITLE "InitElogs" */
static void
InitElogs()
{
    ELOG_INIT(RTELOG);
    ELOG_DEFINE(RTELOG_DEMAND_FETCH, "Demand Fetch", "Demand fetch sector %d");
    ELOG_DEFINE(RTELOG_PREFETCH, "Prefetch", "Prefetch sector %d");
    ELOG_DEFINE(RTELOG_PREFETCH_USED, "Used prefetch",
			 "Used prefetched sector %d");
    ELOG_DEFINE(RTELOG_SWAPOUT, "Swap out", "Swapped out sector %d");
    ELOG_DEFINE(RTELOG_HIT, "Hit", "Hit: waittime %d");
    ELOG_DEFINE(RTELOG_IDLE, "Idle time", "Idle time is %d tics");
    ELOG_DEFINE(RTELOG_PREFTIME, "Prefetch time",
			 "Prefetch action time %d tics");
    ELOG_DEFINE(RTELOG_LASTLEN, "Last length", "Last prefetch took %d tics");
    ELOG_DEFINE(RTELOG_LASTOK, "Last overlap",
			 "Last prefetch overlapped %d tics");
}
