/* @TITLE "alloc.c: simple memory allocation" */

#include <stdio.h>
#include <usdfk.h>

/* @SUBTITLE "AllocGlobal: allocate some shared memory anywhere" */
ANYPTR
AllocGlobal(bytes)
	int bytes;
{
    char *p;

    p = UsAlloc(bytes);
    if (p == (char *)NULL) {
	   printf("AllocGlobal: %d out of shared memory (need %d bytes)\n", 
			UsProc_Node, bytes);
	   CoreDump();
    }
    return(p);
}

/* @SUBTITLE "AllocScatterMatrix: allocate scatter shared memory" */
ANYPTR
AllocScatterMatrix(rows, cols, size)
	int rows, cols, size;
{
    char *p;

    p = UsAllocScatterMatrix(rows, cols, size);
    if (p == (char *)NULL) {
	   printf("AllocScatterMatrix: %d out of shared memory (need %d bytes)\n",
			UsProc_Node, rows*cols*size + rows*sizeof(ANYPTR));
	   CoreDump();
    }
    return(p);
}

/* @SUBTITLE "AllocLocal: allocate some shared memory on local proc" */
ANYPTR
AllocLocal(bytes)
	int bytes;
{
    char *p;

    p = UsAllocLocal(bytes);
    if (p == (char *)NULL) {
	   printf("AllocLocal: %d out of local shared memory (need %d bytes)\n", 
			UsProc_Node, bytes);
	   CoreDump();
    }
    return(p);
}

/* @SUBTITLE "AllocPrivate: allocate some private memory on local proc" */
ANYPTR
AllocPrivate(bytes)
	int bytes;
{
    char *p;

    p = malloc(bytes);
    if (p == (char *)NULL) {
	   printf("AllocPrivate: %d out of private memory (need %d bytes)\n",
			UsProc_Node, bytes);
	   CoreDump();
    }
    return(p);
}
