/* @TITLE "suppt.c - various support functions" */
/* suppt.c:	Support routines for RAPID management functions found in 
 *		interface.c.  These subroutines should NOT be invoked 
 *		directly by application programs: 
 *			AddSectors 
 *			TouchSectorMaps
 * 
 */

static char rcsid[] = "$Id: suppt.c,v 7.1 91/05/09 19:31:27 dfk Tape2 $"; 

/* INCLUDES */

#include <stdio.h>
#include <usdfk.h>
#include "internal.h"

/* @SUBTITLE "AddSectors: add new sectors" */
void
AddSectors (inode_ptr, num, FileIsNew)
	RAPID_INODE *inode_ptr;
	int num;				/* number of sectors to add */
	boolean FileIsNew;		/* true if the file is a newly-created file */
{
    int s;
    SECTOR_MAP_ENTRY *sme;
    
    for (s = 0; s < num; s++)	{
	   sme = RT_smeForSector(inode_ptr, s);
	   bzero (sme, sizeof(SECTOR_MAP_ENTRY));
	   sme->sector_status = FileIsNew? 0 : SS_NONZERO;
	   sme->sector_frame = -1;
    } 
}

/* @SUBTITLE "TouchSectorMaps: touch all sector maps" */
void
TouchSectorMaps(rpd)
	RAPIDFILE *rpd;
{
    int map;				/* index into sector_map_table */
    int num_maps = rpd->num_maps; /* number of sector maps in file */
    
    for (map = 0; map < num_maps; map++)
	 TouchBlock(rpd->sector_map_table[map], rpd->sector_map_size, TRUE);
}

/* @SUBTITLE "AddFrames: Add some frames into the cache" */
/* note that we only allocate as many frames as we have node
 * memories, if we need more. The point here is to provide a 
 * location for the block transfer - the contents don't matter.
 * since contention depends on the node location of the memory,
 * not the address within the node, one frame buffer per memory
 * will do the trick for us. Now we can simulate use of as many 
 * frames as we like, with only one buffer allocated per memory.
 * We use a Scattermatrix to get this effect. In order to free it
 * later, we must remember the "buffers" pointer in the inode.
 */
void
AddFrames(inode_ptr, num_frames)
	RAPID_INODE *inode_ptr;
	int num_frames;		/* the number of frames we want */
{
    FRAME_ENTRY *frame;		/* one frame entry */
    SECTOR *buffers;		/* scattered set of buffers */
    int num_bufs = min(num_frames, ProcsInUse());
    int index;
    
    /* allocate a bunch of buffers */
    buffers = (SECTOR *) AllocScatterMatrix(num_bufs, 1, 
									 inode_ptr->sector_size);
    /* fill in frame table entries */
    for (index = 0; index < num_frames; index++) {
	   frame = inode_ptr->frame_table[index];
	   /* Set up the frame table entry */
	   frame->frame_ptr = buffers[index % num_bufs];
	   frame->frame_sector = -1; /* necessary for new frames */
	   frame->ws_count = 0;
	   frame->frame_lock = 0;
	   frame->frame_status = FS_OLDFRAME;
    }

    /* store buffers in inode so we can free it */
    inode_ptr->buffers = buffers;
    inode_ptr->num_frames = num_frames;
}

/* @SUBTITLE "TouchFrames: Touch frames in the cache" */
void
TouchFrames(rpd)
	RAPIDFILE *rpd;
{
    FRAME_ENTRY *frame;
    int index;
    int num_frames = rpd->num_frames;

    for (index = 0; index < num_frames; index++) {
	   frame = rpd->frame_table[index];
	   TouchBlock(frame->frame_ptr, rpd->sector_size, TRUE);
    }
}
