/* @TITLE "init.c - initialize system" */
/* init.c: RAPID initialization routines. Includes:
 *
 *        InitializeRAPIDSystem() 
 */

static char rcsid[] = "$Id: init.c,v 7.1 91/05/09 19:31:27 dfk Tape2 $"; 

/* INCLUDES */

#include <stdio.h>
#include <usdfk.h>
#include "rapidelog.h"
#include "io.h"
#include "vnode.h"

/* GLOBAL DATA */
int Vnode;				/* see vnode.h */

/* LOCAL FUNCTIONS */

static void InitializeRAPIDSystemAux();
static void InitVnodeForProc();

/* @SUBTITLE "InitializeRAPIDSystem" */
void
InitializeRAPIDSystem ()
{
    /* Perform the initialization on each US process. */
    GenTaskForEachProc (InitializeRAPIDSystemAux, 0);
}

/* parallel */
static void	
InitializeRAPIDSystemAux()
{
    io_init();
    RT_InitPrefetch();
}

/* @SUBTITLE "InitElogs" */
void
InitElogs()
{
    ELOG_INIT(RTELOG);
    ELOG_DEFINE(RTELOG_DEMAND_FETCH, "Demand Fetch", "Demand fetch sector %d");
    ELOG_DEFINE(RTELOG_PREFETCH, "Prefetch", "Prefetch sector %d");
    ELOG_DEFINE(RTELOG_PREFETCH_USED, "Used prefetch",
			 "Used prefetched sector %d");
    ELOG_DEFINE(RTELOG_SWAPOUT, "Swap out", "Swapped out sector %d");
    ELOG_DEFINE(RTELOG_HIT, "Hit", "Hit: waittime %d");
    ELOG_DEFINE(RTELOG_IDLE, "Idle time", "Idle time is %d tics");
    ELOG_DEFINE(RTELOG_PREFTIME, "Prefetch time",
			 "Prefetch action time %d tics");
    ELOG_DEFINE(RTELOG_LASTLEN, "Last length", "Last prefetch took %d tics");
    ELOG_DEFINE(RTELOG_LASTOK, "Last overlap",
			 "Last prefetch overlapped %d tics");
}

/* @SUBTITLE "InitVnodes - generate Vnode numbers" */
void
InitVnodes()
{
    short *counter;
    
    counter = (short *)AllocGlobal(sizeof(short));
    if (counter == NULL) {
	   fprintf(stderr, "No memory in InitVnodes()\n");
	   exit (1);
    }
    *counter = 0;

    GenTaskForEachProc(InitVnodeForProc, counter);

    UsFree(counter);
}

static void
InitVnodeForProc(counter)
	short *counter;
{
    /* Unique to this proc, and definitely contiguously numbered from 0 */
    Vnode = Atomic_add(counter, 1);
}
