/* @TITLE "rapidelog.h - elog definitions for RAPID system" */
/* rapidelog.h: Declarations for event logging the RAPID library. */
/* $Id: rapidelog.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

#define ELOG
#include <elog.h>

#define GOAWAY() schedule_coroutine();

#define RTELOG "data/rapid"			/* name of event log */
#define RTELOG_ABORTNAME "data/abort.elog" /* final name of aborted log */

#define RTELOG_DEMAND_FETCH	10
#define RTELOG_PREFETCH_MARK	11 /* not used (obsolete) */
#define RTELOG_PREFETCH 		12
#define RTELOG_PREFETCH_USED	13
#define RTELOG_SWAPOUT  		14
#define RTELOG_HIT  		15
#define RTELOG_IDLE	    		16
#define RTELOG_PREFTIME 		17 /* not recorded */
#define RTELOG_LASTLEN  		18 /* not recorded */
#define RTELOG_LASTOK		19 /* not recorded */
#define RTELOG_DISKUSED 		20
#define RTELOG_DISKWAIT 		21
#define RTELOG_PREDICT 		22
#define RTELOG_MISTAKE  		23
#define RTELOG_SCANQ  		24
#define RTELOG_WRITEBACK		25
#define RTELOG_LEFTGWS  		26 

/* for Prefetch-Algorithm use; specific to each one */
#define RTELOG_PFA    		30
/* Reserved: RTELOG_PFA+0 ... RTELOG_PFA+9 */

#define RTELOG_SWITCHCOUNT	40
#define RTELOG_SWITCHLOCAL	41
