/* @TITLE "fifolock - a FIFO locking protocol" */
/* $Id: fifolock.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */
/* 
 * fifolock - a FIFO spin lock
 *
 * This is just like a normal spin lock except that 
 * it lets processes enter in FIFO order. It uses two 
 * counters, one for entry, one for exit. It is alright
 * if they overflow, since we use a != in our conditional.
 * The only constraint is that the number of procs be smaller
 * than the number of integers in a short. If that's a problem, 
 * use longs.
 */

/* needs usdfk.h */

typedef struct fifolock_s FIFOLOCK;
struct fifolock_s {
    unsigned short entry;
    unsigned short exit;
};

/* Allocate a FIFOLOCK */
#define AllocFIFO(fifo) \
{ \
    (fifo) = (FIFOLOCK *)UsAlloc(sizeof(FIFOLOCK)); \
    (fifo)->entry = (fifo)->exit = 0; \
}

/* Free a FIFOLOCK */
#define FreeFIFO(fifo) UsFree(fifo)

/* Lock a FIFOLOCK */
#define LockFIFO(fifo, delay) \
{   unsigned short myturn; \
    myturn = (unsigned short)Atomic_add(&((fifo)->entry), 1); \
    while (myturn != (fifo)->exit) \
	 UsWait(delay); \
}

/* Test a FIFOLOCK (TRUE if lock is set) */
#define BusyFIFO(fifo) ((fifo)->entry != (fifo)->exit)

/* Unlock a FIFOLOCK */
#define UnlockFIFO(fifo) Atomic_add(&((fifo)->exit), 1)
