/* @TITLE "coroutine.h - definitions for coroutine package" */
/* $Id: coroutine.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */
/*
 * Butterfly Chrysalis High-Level Coroutine Package
 *
 * This package provides a convenient set of functions for using coroutines
 * in a Chrysalis program.
 *
 * Rick LaRowe,  Duke University
 *
 */


#define CRTN_RUNNING	0x00000001	/* current coroutine */
#define CRTN_READY	0x00000002	/* coroutine is ready to run */
#define CRTN_BLOCKED	0x00000004	/* coroutine has been blocked */

#define CERR_OK			0	/* OK - no erros */
#define CERR_NO_INIT		1	/* coroutines not initialized */
#define CERR_ALRDY_RUNNING	2	/* coroutines already initialized */
#define CERR_DEL_INIT		3	/* cannot delete CID 1 */
#define CERR_NO_EXIST		4	/* CID does not exist */
#define CERR_NOT_RDY		5	/* CID not ready to run */
#define CERR_ONLY_THRD		6	/* cannot block only ready coroutine */
#define CERR_NOT_BLKD		7	/* CID not blocked */

int initialize_coroutines();		/* no args */
int  create_coroutine();		/* stk_sz, function, arg */
int delete_coroutine();			/* CID */
void schedule_coroutine();		/* no args */
int transfer_coroutine();		/* CID */
int block_coroutine();			/* CID - 0 for current */
int unblock_coroutine();		/* CID */
int  coroutine_id();			/* no args */
int  coroutine_status();		/* CID - 0 for current */


