/* @TITLE "driver.h - header for all of driver" */
/* driver.h: Definitions to link driver together */

/* $Id: driver.h,v 7.1 91/05/09 19:34:39 dfk Tape2 $ */

#include "vnode.h"

extern void SynchPoint();
extern void SynchPointNeighbor();
extern void SynchOut();

extern void SignalInit();	/* Set up for debug-abort on signal */

extern char Directory_name[];	/* name of the Data directory */
extern char ElogData_name[];	/* base name of the files */
extern char DataFile_name[];	/* name of the data file */
extern char ElogFile_name[];	/* name of the elog file */
extern int ElogDumpLimit;	/* highest numbered trial to dump elog */
extern boolean ElogDumpIgnore; /* ignore further changes to ElogDumpLimit */

extern FILE *DataFile;		/* data file */

extern RAPIDFILE *my_rpd;	/* Private pointer to the (open) RAPIDFILE */

extern char *my_buf;		/* Private buffer for reading chunks */

extern int InputLine;		/* line in input test file */

/* prefetch parameters */
extern boolean Caching;		/* are we caching? */
extern boolean Prefetch;		/* are we prefetching? */
extern boolean Baseline;		/* Should we do a baseline n-prefetch test? */
extern boolean PrefetchAtSynch; /* prefetch at synch points? */
extern boolean PrefetchBufHit; /* prefetch while waiting for bufhit? */
extern boolean PrefetchDemand; /* prefetch while demand fetch? */
extern int PrefetchLead;		/* prefetch lead */
extern int PrefetchLimit;	/* prefetch limit */
extern int PrefetchMin;		/* prefetch min time */
extern short PrefetchAlg;	/* Prefetch algorithm code (from PFA_*) */
extern int PrefetchParm;		/* Prefetch algorithm parameter */
extern int NumFrames;		/* number of frames to allocate */
extern boolean DoingWrites;	/* are we doing a writable-file test? */
extern int WriteAlg;		/* writeback algorithm */
extern boolean FileIsNew;	/* is the file newly created? */

extern char *Pattern;		/* pattern file name */

extern int wss;			/* working-set size for WS alg */

extern int blocksize;		/* size of disk blocks */

extern int ndisks;			/* number of disks */
extern int disktime;		/* disk access time in msec (0 -> use default) */

/* see also SynchCodes[] in driver.c */
extern int SynchStyle;		/* synchronization style */
#define SYNCH_NONE 0		/* no synch at all */
#define SYNCH_EACH 1		/* synch after each does 'count' chunks */
#define SYNCH_TOTAL 2		/* synch after total of 'count' chunks */
#define SYNCH_PORTION 3		/* synch after each portion */
#define SYNCH_NEIGHBOR 4		/* synch between neighbors only */
extern int SynchCount;		/* count mentioned in style */

extern int Nprocs;			/* number of processors */
extern int Ntrials;			/* number of trials */

/* driver ELOG codes */
#define E_CHUNKSIZE 0		/* for now; i may change it later */
#define E_PROCS 1
#define E_SYNCHSTART 2
#define E_SYNCHEND 3
#define E_READ 4
#define E_BEGIN 5
#define E_END 6
#define E_COMP 7
#define E_ABORT 8			/* see signal.c */
#define E_WRITE 9

extern int trial;			/* current trial number */

extern TICS TotalTime; /* time for the test */

extern SYNCH *SynchCounter;	/* synchronization variable */
extern TICS *SynchTime; /* total time spent at each synchronization */
extern short *Nsynchs;		/* number of proc-syncs in program */

/* Body and generator functions; used by driver main() */
extern TICS Body();			/* returns total time */
extern void BodyInit();

/* argument-parsing, used by main() (from args.c) */
extern boolean GetArgsFromFile();
extern boolean ParseArgs();
