/* @TITLE "cotest.c - test coroutine package" */
/* cotest.c - test file for coroutines 
 * DFK 12/7/88 
 */

static char rcsid[] = "$Id: cotest.c,v 6.0 89/11/06 15:48:46 dfk Exp Locker: dfk $"; 

#include <stdio.h>
#include "coroutine.h"

void other();

main()
{
    int cid;
    int me;
    
    initialize_coroutines();
    
    me = coroutine_id();
    printf("A0: I am cid %d, status %d\n", me, coroutine_status(me));
    
    cid = create_coroutine(1000,other,me);
    
    printf("A1: Created cid %d, status %d\n", cid, coroutine_status(cid));
    schedule_coroutine();
    printf("A3: Now I'm back\n");
    transfer_coroutine(cid);
    printf("A6: Back after block test\n");
    delete_coroutine(cid);
    printf("A7: Coroutine deleted - try to schedule\n");
    schedule_coroutine();
    printf("A8: OK, nothing happened.\n");
    printf("A9: Bye\n");
}

void
other(him)
	int him;
{
    printf("B2: Coroutine %d is here with arg %d\n", coroutine_id(), him);
    schedule_coroutine();
    printf("B4: Transfer worked\n");
    block_coroutine(him);
    schedule_coroutine();
    printf("B5: He is blocked (%d), so we're still here\n",
		 coroutine_status(him));
    unblock_coroutine(him);
    transfer_coroutine(him);
    printf("B?: I didn't expect to be here!\n");
}
