| Hacked from Chrys4.0 coroutine.a68 by David Kotz 12/6/88
| This module provides Mach level implementation of
| COROUTINES.
| $Id: corout.s,v 6.1 90/08/02 09:34:09 dfk Exp Locker: dfk $

| A coroutine is a light-weight task which allows for explicit
| (voluntary) blocking.  A coroutine can block itself by transfering
| control to another (blocked) coroutine.

| A Coroutine is created by Make_Coroutine
|

| Blocking and transfer of control is done by Transfer_Coroutine


| Doing a return from a coroutine  will
| cause a throw from Coroutine_return_error

|********************************************************************

	.text
	.even

|********************************************************************
| Make_Coroutine(stack,size,procedure,param,thread_ptr,)
|********************************************************************
| a6(8) = stack
| a6(c) = size
| a6(10) = procedure
| a6(14) = param
| a6(18) = thread_ptr
	.globl Make_Coroutine
	.globl _Make_Coroutine
	.globl __Make_Coroutine
Make_Coroutine:
_Make_Coroutine:
__Make_Coroutine:
	link a6,#0
	
	movl a6,a0			|Use a0 to get args
	movl #0,a6
	movl a0@(0x8),sp			|sp <- new stack
	addl a0@(0xc),sp			|sp <- sp + size (goto top)

| Fake Caller's stack frame - You should never need return PC
	movl a0@(0x14),sp@-		| param
	movl #Coroutine_return_error,sp@- |put error routine as return pc


| Make initial state for new thread - 
        movl a0@(0x10),sp@-		| resume address
	moveml #0xfffe, sp@-		| save a6-a0, d7-d0

| 68020 & 68881: save 68881 state
|	fnop
	.word 0xf280,0x0000	

|	fmovem fp0-fp7,sp@-
	.word 0xf227,0xe0ff
|       fmovem fpcr/fpsr/fpiar,sp@-
	.word 0xf227,0xbc00

| Place magic cookie on bottom of stack for sanity check.
	movl sp,sp@-			| bottom of stack <- sp

	
	movl a0,a6
	movl a0@(0x18),a0		| *thread_ptr <- bottom of stac
	movl sp,a0@

	unlk a6
	rts			


|*********************************************************************
| Transfer_Coroutine(this_thread_ptr, dest_thread_ptr)
|*********************************************************************
	.globl Transfer_Coroutine
	.globl _Transfer_Coroutine
	.globl __Transfer_Coroutine
Transfer_Coroutine:
_Transfer_Coroutine:
__Transfer_Coroutine:
| a7(0x4) = this_thread_ptr
| a7(0x8) = dst_thread_ptr

| Save STATE
	link a6,#0  | for debugger ?????
	movl sp@+,a6	| don't muck up a6
	movl sp@(0x4),this_thread_ptr
	movl sp@(0x8),dst_thread_ptr

	moveml #0xfffe, sp@-		| save a6-a0, d7-d0

| 68020 & 68881:  save 68881 regs
|	fnop
	.word 0xf280,0x0000	

|	fmovem fp0-fp7,sp@-
	.word 0xf227,0xe0ff
|       fmovem fpcr/fpsr/fpiar,sp@-
	.word 0xf227,0xbc00

| Place magic cookie on bottom of stack for sanity check.
	movl sp,sp@-			| bottom of stack <- sp	 


	movl this_thread_ptr,a0
	movl sp,a0@			| *thread_ptr <- bottom of stack


| Do State and Stack restore on destination thread
	movl dst_thread_ptr,a0
	
	movl a0@,a1
	movl a1@,d0		| test for bus error

	movl a0@,sp		| sp <- *dst_thread_ptr

|Check sanity of a0 - does it really point to the bottom of a coroutine stack?
	movl sp@+,a0
	cmpl a0,sp
	bne  Coroutine_sanity_error
	
	| restore 68881 state
	.word	0xf21f, 0x9c00	| fmovem sp@+,fpcr/fpsr/fpiar
	.word	0xf21f, 0xd0ff	| fmovem sp@+,fp0-fp7

	moveml  sp@+, #0x7FFF            | restore regs d0 thru a6
	rts				| jmp to (Resume PC)


|********************************************************************
| Coroutine_return_error
|********************************************************************

Coroutine_return_error:
__Coroutine_return_error:
	clrl	sp@-
	pea	.L4
	clrl	sp@-
	jbsr	_throw
	lea	sp@(12),sp
	rts

|********************************************************************
| Coroutine_sanity_error
|********************************************************************

Coroutine_sanity_error:
__Coroutine_sanity_error:
	clrl	sp@-
	pea	.L5
	clrl	sp@-
	jbsr	_throw
	lea	sp@(12),sp
	rts

	.data 
dst_thread_ptr: 
	.blkl 1
this_thread_ptr:
	.blkl 1
.L4:	.asciz	"Illegal: Tried to do return from coroutine"
.L5:	.asciz	"Invalid destination coroutine identifier"

|	.end
