# Produce the LBE for each interval
# Handles the newer logs (with E_END and E_BEGIN events) 

BEGIN {proc = 0; node=""; maxint = 0; interval = 0;
    E_SYNCHSTART = 2;
    E_SYNCHEND = 3;
    E_BEGIN = 5;
    E_END = 6;
}

# Start of a new node
$2 != node {
    node = $2;
    if (interval >= maxint)
    	   maxint = interval;
    starttime = 0; interval = 1;
}

# begin interval
$3 == E_SYNCHEND || $3 == E_BEGIN {
    starttime = $1;
    next;
}

# end interval
# E_END is not a real interval on this proc, except for SYNCH_NONE,
# which we distinguish by it being interval #1
$3 == E_SYNCHSTART || ($3 == E_END && interval == 1) { 
    lasttime = $1;
    elapsed = lasttime-starttime;
    if (elapsed > time[interval]) {
    	   time[interval] = elapsed;
    }
    sum[interval] += elapsed;
    count[interval]++;
    interval++;
    next;
}

END {
    for (i=1; i < maxint; i++)
    	   printf "%5.3f\n", (sum[i]+0.0)/count[i]/time[i];
}
