# Produce a description of each interval 
# Handles the newer logs (with E_END and E_BEGIN events) 

BEGIN {proc = 0; node=""; maxint = 0; interval = 0;
    E_SYNCHSTART = 2;
    E_SYNCHEND = 3;
    E_BEGIN = 5;

    print "Length of each interval for each processor"
    print ""
    print "node                                 Interval"

    printf "    "
    for (i=1; i <= 13; i++)
    	   printf " Int %d ", i;
    print ""
    printf "----"
    for (i=1; i <= 13; i++)
    	   printf " ------";
    print ""
}

# Start of a new node
$2 != node {
    proc++; node = $2;
    if ((proc-1) % 5 == 0) 
    	   print "";
    printf "\n %2s ", node
    if (interval >= maxint)
    	   maxint = interval;
    starttime = 0; interval = 1;
}

# begin interval
$3 == E_SYNCHEND || $3 == E_BEGIN {
    starttime = $1;
}

# end interval
# we don't watch for E_END since this is not a real interval on this proc
# (except for SYNCH_NONE, when we should look for E_END.)
$3 == E_SYNCHSTART { 
    lasttime = $1;
    elapsed = lasttime-starttime;
    if (elapsed > time[interval]) {
    	   time[interval] = elapsed;
    }
    sum[interval] += elapsed;
    count[interval]++;
    printf " %6d", elapsed;
    interval++;
}

END {
    printf "\n\nMax:"
    for (i=1; i < maxint; i++)
    	   printf " %6d", time[i];
    printf "\nLBE:"
    for (i=1; i < maxint; i++)
    	   printf " %6.3f", (sum[i]+0.0)/count[i]/time[i];
    printf "\n";
}
