# gantt.awk: produces several output files that plot the different
# activities of a log. Each file has one type of event.
# The x value is time, the y value is processor number.

BEGIN{
    	   E_SYNCHSTART = 2;			synchstart=0;
    	   E_SYNCHEND = 3; 				synchend=0;
	   E_READ = 4;     				read=1;
	   RFELOG_DEMAND_FETCH = 10;		demand=2;
	   RFELOG_PREFETCH = 12;			prefetch=3;
#	   RFELOG_PREFETCH_USED = 13;
	   RFELOG_HIT = 15;				forehit=4; backhit=5;
	   RFELOG_IDLE = 16;			
#	   RFELOG_PREFTIME = 17;
	   RFELOG_MISTAKE = 23;	  		mistake=6;
}

$3 == RFELOG_IDLE && last == RFELOG_DEMAND_FETCH {
    print $1,10*($2+1)+demand > "demand.start"
    print $1+$4,10*($2+1)+demand > "demand.end"
}

{last = $3}

$3 == E_READ {print $1,10*($2+1)+read > "read"; next}

$3 == RFELOG_DEMAND_FETCH {next}
$3 == RFELOG_HIT {
    if ($4 > 0) {
        print $1,10*($2+1)+forehit > "hit.start";
        print $1+$4,10*($2+1)+forehit > "hit.end"; 
    } else {
        print $1,10*($2+1)+backhit > "hit.start";
        print $1+$4,10*($2+1)+backhit > "hit.end"; 
    }
    next
}

$3 == RFELOG_PREFETCH {print $1,10*($2+1)+prefetch > "pref"; next}
$3 == RFELOG_MISTAKE {print $1,10*($2+1)+mistake > "mistake"; next}

$3 == E_SYNCHSTART {print $1,10*($2+1)+synchstart > "start"; next}
$3 == E_SYNCHEND {print $1,10*($2+1)+synchend > "end"; next}
