# Compute the average demand-wait time

BEGIN { RFELOG_HIT = 15; RFELOG_IDLE = 16; E_SYNCHSTART = 2;
RFELOG_DEMAND_FETCH = 10;
insynch = 0;
idle = 0;
count = 0;
idlecounts = 0;
}

# Buffer hit
$3 == RFELOG_IDLE {
	   if (idlecounts) {
	       idle += ($4 > 0 ? $4 / 16 : 0);
	       count++;
	   }
	   next
}

$3 == RFELOG_HIT { idlecounts = 0; next }

$3 == RFELOG_DEMAND_FETCH { idlecounts = 1; next }

$3 == E_SYNCHSTART { idlecounts = 0; next }


END {
    if (count > 0) 
    	   print idle / count;
    else
    	   print 0
}