# for codelog

#-- driver events:
#define E_PROCS		1	# of procs
#define E_SYNCHSTART	2
#define E_SYNCHEND		3	
#define E_READ	 		4	chunk #
#define E_BEGIN		5
#define E_END	 		6
#define E_COMP			7	chunk #
#define E_ABORT		8	signal #

#-- ramfile events:
#define RTELOG_DEMAND_FETCH	10	sector
#define RTELOG_PREFETCH_MARK	11	(not used)
#define RTELOG_PREFETCH		12	sector
#define RTELOG_PREFETCH_USED	13	sector
#define RTELOG_SWAPOUT  		14	sector
#define RTELOG_HIT  		15	wait time
#define RTELOG_IDLE	    		16	time (hit, demand, synch)
#define RTELOG_PREFTIME 		17	RT_Prefetch elapsed time
#define RTELOG_LASTLEN  		18	length of last RT_Prefetch
#define RTELOG_LASTOK		19	overlapped part of LASTLEN
#define RTELOG_DISKUSED 		20   disk number
#define RTELOG_DISKWAIT 		21   wait time (tics)
#define RTELOG_PREDICT 		22   predict notify time (tics)
#define RTELOG_MISTAKE 		23   sector
#define RTELOG_SCANQ 		24   0
#define RTELOG_WRITEBACK		25   sector
#define RTELOG_LEFTGWS  		26   sector

#define RTELOG_GAPSNOTIFY	30   block
#define RTELOG_GAPSSTART		31   block
#define RTELOG_GAPSEND  		32   reason: 0=maxjump, 1=jumpback, 2=incomplete
#define GAPSELOG_RANDOM RTELOG_PFA+3	Random() time (tics)
#define GAPSELOG_CONTIN RTELOG_PFA+4	Contin() time (tics)
#define GAPSELOG_WFIFO  RTELOG_PFA+5	Watch_fifo wait time (tics)
#define GAPSELOG_WATCH  RTELOG_PFA+6	Watch() time (tics)
#define GAPSELOG_TOSEQ  RTELOG_PFA+7	ToSequential() time (tics)

#define RTELOG_SWITCHCOUNT	40
#define RTELOG_SWITCHLOCAL	41

BEGIN {}

{ printf "%d Proc %2d ", $1, $2; }

$3 == 1 { printf "%d processors\n", $4; next }
$3 == 2 { printf "SynchStart\n"; next }
$3 == 3 { printf "SynchEnd\n"; next }
$3 == 4 { printf "Read block %d\n", $4; next }
$3 == 5 { printf "BEGIN\n"; next }
$3 == 6 { printf "END\n"; next }
$3 == 7 { printf "Compute block %d\n", $4; next }
$3 == 8 { printf "Abort on signal %d\n", $4; next }

$3 == 10 { printf "Demand block %d\n", $4; next }
$3 == 11 { printf "Mark block %d\n", $4; next }
$3 == 12 { printf "Prefetch block %d\n", $4; next }
$3 == 13 { printf "Used prefetch %d\n", $4; next }
$3 == 14 { printf "Swapout block %d\n", $4; next }
$3 == 15 { printf "Hit wait %d tics\n", $4; next }
$3 == 16 { printf "Idle %d tics\n", $4; next }
$3 == 17 { printf "Prefetch time %d tics\n", $4; next }
$3 == 18 { printf "Last prefetch time %d tics\n", $4; next }
$3 == 19 { printf "Overlapped part of last prefetch %d tics\n", $4; next }
$3 == 20 { printf "Disk used: %d\n", $4; next }
$3 == 21 { printf "Disk wait %d tics\n", $4; next }
$3 == 22 { printf "Notify %d tics\n", $4; next }
$3 == 23 { printf "Mistake block %d\n", $4; next }
$3 == 24 { printf "Scan unready queue\n"; next }
$3 == 25 { printf "Write back sector %d\n", $4; next }
$3 == 26 { printf "Sector %d left GWS\n", $4; next }

$3 == 30 { printf "GAPS notify block %d\n", $4; next }
$3 == 31 { printf "GAPS start at block %d\n", $4; next }
$3 == 32 { printf "GAPS end "; 
    if ($4 == 0)
      print "maxjump";
    else if ($4==1)
      print "jumpback";
    else if ($4 == 2)
      print "incomplete";
    next
}
$3 == 33 { printf "GAPS Random time: %d tics\n", $4; next }
$3 == 34 { printf "GAPS Contin time: %d tics\n", $4; next }
$3 == 35 { printf "GAPS Watch_fifo time: %d tics\n", $4; next }
$3 == 36 { printf "GAPS Watch time: %d tics\n", $4; next }
$3 == 37 { printf "GAPS ToSequential time: %d tics\n", $4; next }

$3 == 40 { printf "SWITCH count %d\n", $4; next }
$3 == 41 { printf "SWITCH to %s\n", $4 ? "LOCAL" : "GLOBAL"; next }

{ printf "UNKNOWN %d %d\n", $3, $4}
 
